/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.PersistencePropertiesEnum;
import co.codewizards.cloudstore.local.PersistencePropertiesProvider;
import co.codewizards.cloudstore.local.db.AbstractDatabaseAdapter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyDatabaseAdapter
extends AbstractDatabaseAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DerbyDatabaseAdapter.class);
    private Map<String, String> persistenceProperties;
    private String connectionURL;
    private String connectionDriverName;
    private String connectionUserName;
    private String connectionPassword;

    @Override
    protected void createDatabase() throws Exception {
        this.initProperties();
        this.initDriverClass();
        this.connectionURL = Objects.requireNonNull(this.connectionURL, "connectionURL").trim() + ";create=true";
        Connection connection = this.createConnection();
        connection.close();
    }

    private void initDriverClass() {
        if (StringUtil.isEmpty((String)this.connectionDriverName)) {
            return;
        }
        try {
            Class.forName(this.connectionDriverName);
        }
        catch (Throwable e) {
            logger.warn("initDriverClass" + e, e);
        }
    }

    public Connection createConnection() throws SQLException {
        if (StringUtil.isEmpty((String)this.connectionUserName) && StringUtil.isEmpty((String)this.connectionPassword)) {
            return DriverManager.getConnection(this.connectionURL);
        }
        return DriverManager.getConnection(this.connectionURL, this.connectionUserName, this.connectionPassword);
    }

    private void initProperties() {
        PersistencePropertiesProvider persistencePropertiesProvider = new PersistencePropertiesProvider(this.getRepositoryIdOrFail(), this.getLocalRootOrFail());
        this.persistenceProperties = persistencePropertiesProvider.getPersistenceProperties();
        this.connectionDriverName = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_DRIVER_NAME.key);
        this.connectionURL = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_URL.key);
        this.connectionUserName = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_USER_NAME.key);
        this.connectionPassword = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_PASSWORD.key);
    }
}

