/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.dto;

import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import java.util.Objects;
import org.subshare.core.dto.HistoFrameDto;
import org.subshare.local.persistence.HistoFrame;
import org.subshare.local.persistence.HistoFrameDao;

public class HistoFrameDtoConverter {
    private final LocalRepoTransaction transaction;

    public static HistoFrameDtoConverter create(LocalRepoTransaction transaction) {
        return (HistoFrameDtoConverter)ObjectFactoryUtil.createObject(HistoFrameDtoConverter.class, (Object[])new Object[]{transaction});
    }

    protected HistoFrameDtoConverter(LocalRepoTransaction transaction) {
        this.transaction = Objects.requireNonNull(transaction, "transaction");
    }

    public HistoFrameDto toHistoFrameDto(HistoFrame histoFrame) {
        Objects.requireNonNull(histoFrame, "histoFrame");
        HistoFrameDto result = new HistoFrameDto();
        result.setHistoFrameId(histoFrame.getHistoFrameId());
        result.setFromRepositoryId(histoFrame.getFromRepositoryId());
        result.setSealed(histoFrame.getSealed());
        result.setSignature(histoFrame.getSignature());
        return result;
    }

    public HistoFrame putHistoFrameDto(HistoFrameDto histoFrameDto) {
        Objects.requireNonNull(histoFrameDto, "histoFrameDto");
        HistoFrameDao dao = (HistoFrameDao)((Object)this.transaction.getDao(HistoFrameDao.class));
        HistoFrame result = dao.getHistoFrame(histoFrameDto.getHistoFrameId());
        if (result == null) {
            result = new HistoFrame(histoFrameDto.getHistoFrameId());
        }
        result.setFromRepositoryId(histoFrameDto.getFromRepositoryId());
        result.setSealed(histoFrameDto.getSealed());
        result.setSignature(histoFrameDto.getSignature());
        result = (HistoFrame)dao.makePersistent(result);
        return result;
    }
}

