/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.selectkey;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.event.ActionEvent;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.subshare.core.pgp.PgpKey;
import org.subshare.gui.pgp.selectkey.SelectPgpKeyPane;

public class SelectPgpKeyDialog
extends Stage {
    private final SelectPgpKeyPane selectPgpKeyPane;
    private List<PgpKey> selectedPgpKeys;

    public SelectPgpKeyDialog(Window owner, List<PgpKey> pgpKeys, Collection<PgpKey> selectedPgpKeys, SelectionMode selectionMode, String headerText) {
        Objects.requireNonNull(owner, "owner");
        Objects.requireNonNull(pgpKeys, "pgpKeys");
        this.setResizable(false);
        this.initStyle(StageStyle.UTILITY);
        this.initModality(Modality.APPLICATION_MODAL);
        this.initOwner(owner);
        this.setIconified(false);
        this.selectPgpKeyPane = new SelectPgpKeyPane(pgpKeys, selectedPgpKeys, selectionMode, headerText){

            @Override
            protected void okButtonClicked(ActionEvent event) {
                SelectPgpKeyDialog.this.okButtonClicked();
            }

            @Override
            protected void cancelButtonClicked(ActionEvent event) {
                SelectPgpKeyDialog.this.cancelButtonClicked();
            }
        };
        this.setScene(new Scene((Parent)this.selectPgpKeyPane));
        this.setOnShown(event -> {
            this.requestFocus();
            this.selectPgpKeyPane.requestFocus();
        });
        this.getScene().addEventFilter(KeyEvent.ANY, event -> {
            switch (event.getCode()) {
                case ENTER: {
                    event.consume();
                    if (event.getEventType() != KeyEvent.KEY_RELEASED) break;
                    this.okButtonClicked();
                    break;
                }
                case ESCAPE: {
                    event.consume();
                    if (event.getEventType() != KeyEvent.KEY_RELEASED) break;
                    this.cancelButtonClicked();
                    break;
                }
            }
        });
    }

    protected void okButtonClicked() {
        this.selectedPgpKeys = new ArrayList<PgpKey>((Collection<PgpKey>)this.selectPgpKeyPane.getSelectedPgpKeys());
        this.close();
    }

    protected void cancelButtonClicked() {
        this.selectedPgpKeys = null;
        this.close();
    }

    public List<PgpKey> getSelectedPgpKeys() {
        return this.selectedPgpKeys;
    }
}

