/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.dto;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.subshare.core.dto.CryptoKeyPart;
import org.subshare.crypto.CipherOperationMode;

public enum CryptoKeyRole {
    clearanceKey(CryptoKeyPart.publicKey, CryptoKeyPart.privateKey),
    subdirKey(CryptoKeyPart.sharedSecret, CryptoKeyPart.publicKey, CryptoKeyPart.privateKey),
    fileKey(CryptoKeyPart.sharedSecret),
    backlinkKey(CryptoKeyPart.sharedSecret),
    dataKey(CryptoKeyPart.sharedSecret);

    private final CryptoKeyPart[] cryptoKeyParts;
    private final CryptoKeyPart[][] cipherOperationModeOrdinal2CryptoKeyParts;

    private CryptoKeyRole(CryptoKeyPart ... cryptoKeyParts) {
        AssertUtil.assertNotNullAndNoNullElement((Object[])cryptoKeyParts, (String)"cryptoKeyParts");
        if (cryptoKeyParts.length < 1) {
            throw new IllegalArgumentException("cryptoKeyParts.length < 1");
        }
        this.cryptoKeyParts = cryptoKeyParts;
        this.cipherOperationModeOrdinal2CryptoKeyParts = this.createCipherOperationModeOrdinal2CryptoKeyParts();
    }

    private CryptoKeyPart[][] createCipherOperationModeOrdinal2CryptoKeyParts() {
        CryptoKeyPart[][] result = new CryptoKeyPart[CipherOperationMode.values().length][];
        for (CipherOperationMode cipherOperationMode : CipherOperationMode.values()) {
            List<CryptoKeyPart> filtered = this.filterCryptoKeyParts(cipherOperationMode);
            result[cipherOperationMode.ordinal()] = filtered.toArray(new CryptoKeyPart[filtered.size()]);
        }
        return result;
    }

    private List<CryptoKeyPart> filterCryptoKeyParts(CipherOperationMode cipherOperationMode) {
        switch (cipherOperationMode) {
            case DECRYPT: 
            case ENCRYPT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown cipherOperationMode: " + cipherOperationMode);
            }
        }
        ArrayList<CryptoKeyPart> result = new ArrayList<CryptoKeyPart>(this.cryptoKeyParts.length);
        block8: for (CryptoKeyPart cryptoKeyPart : this.cryptoKeyParts) {
            switch (cryptoKeyPart) {
                case privateKey: {
                    if (CipherOperationMode.DECRYPT != cipherOperationMode) continue block8;
                    result.add(cryptoKeyPart);
                    continue block8;
                }
                case publicKey: {
                    if (CipherOperationMode.ENCRYPT != cipherOperationMode) continue block8;
                    result.add(cryptoKeyPart);
                    continue block8;
                }
                case sharedSecret: {
                    result.add(cryptoKeyPart);
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unknown cryptoKeyPart: " + (Object)((Object)cryptoKeyPart));
                }
            }
        }
        return result;
    }

    public CryptoKeyPart[] getCryptoKeyParts() {
        return this.cryptoKeyParts;
    }

    public CryptoKeyPart[] getCryptoKeyParts(CipherOperationMode cipherOperationMode) {
        Objects.requireNonNull(cipherOperationMode, "cipherOperationMode");
        return this.cipherOperationModeOrdinal2CryptoKeyParts[cipherOperationMode.ordinal()];
    }
}

