/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.repo.local.AbstractLocalRepoTransactionListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.persistence.LocalRepository;
import co.codewizards.cloudstore.local.persistence.LocalRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import org.subshare.core.Cryptree;
import org.subshare.core.GrantAccessDeniedException;
import org.subshare.core.ReadAccessDeniedException;
import org.subshare.core.WriteAccessDeniedException;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.SignableVerifier;
import org.subshare.core.sign.WriteProtected;
import org.subshare.core.user.UserRepoKeyPublicKeyLookup;
import org.subshare.local.CryptreeImpl;
import org.subshare.local.persistence.LocalRepositoryType;
import org.subshare.local.persistence.SsLocalRepository;
import org.subshare.local.persistence.SsRepoFile;
import org.subshare.local.persistence.UserRepoKeyPublicKeyLookupImpl;

public class VerifySignableAndWriteProtectedEntityListener
extends AbstractLocalRepoTransactionListener
implements StoreLifecycleListener {
    private final Set<Signable> signables = new HashSet<Signable>();
    private SignableVerifier signableVerifier;
    private LocalRepository localRepository;
    private LocalRepositoryType localRepositoryType;

    public int getPriority() {
        return -100;
    }

    public void onBegin() {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        PersistenceManager pm = ((ContextWithPersistenceManager)tx).getPersistenceManager();
        pm.addInstanceLifecycleListener((InstanceLifecycleListener)this, new Class[]{Signable.class});
    }

    public void preStore(InstanceLifecycleEvent event) {
    }

    public void postStore(InstanceLifecycleEvent event) {
        Object persistentInstance = event.getPersistentInstance();
        Signable signable = (Signable)persistentInstance;
        this.signables.add(signable);
    }

    public void removeSignable(Signable signable) {
        Objects.requireNonNull(signable, "signable");
        this.signables.remove(signable);
    }

    public void onCommit() {
        this.assertAllRepoFilesAreSignedOnServer();
        while (!this.signables.isEmpty()) {
            Iterator<Signable> iterator = this.signables.iterator();
            Signable signable = iterator.next();
            iterator.remove();
            this.assertSignableOk(signable);
        }
    }

    private void assertAllRepoFilesAreSignedOnServer() {
        if (LocalRepositoryType.SERVER != this.getLocalRepositoryType()) {
            return;
        }
        SsLocalRepository localRepository = (SsLocalRepository)this.getLocalRepository();
        if (localRepository.isAssertedAllRepoFilesAreSigned()) {
            return;
        }
        LocalRepoTransaction tx = this.getTransactionOrFail();
        RepoFileDao repoFileDao = (RepoFileDao)tx.getDao(RepoFileDao.class);
        if (repoFileDao.getObjectsCount() < 2L) {
            return;
        }
        for (RepoFile rf : repoFileDao.getObjects()) {
            SsRepoFile ssrf = (SsRepoFile)rf;
            if (ssrf.getSignature() != null) continue;
            throw new IllegalStateException("It seems, the root still has no signature! The root should be signed (i.e. uploaded *with* signature), before any other directory/file is uploaded to the server! repoFileMissingSignature: " + rf);
        }
        localRepository.setAssertedAllRepoFilesAreSigned(true);
    }

    private void assertSignableOk(Signable signable) {
        if (JDOHelper.isDeleted((Object)signable)) {
            return;
        }
        if (signable.getSignature() == null) {
            if (LocalRepositoryType.SERVER == this.getLocalRepositoryType()) {
                throw new SignatureException(signable.toString() + ": Missing signature! On the server, every Signable must be signed!");
            }
        } else {
            Cryptree cryptree = (Cryptree)this.getTransactionOrFail().getContextObject(Cryptree.class);
            try {
                if (cryptree != null && signable instanceof WriteProtected) {
                    ((CryptreeImpl)cryptree).assertSignatureOk((WriteProtected)signable);
                } else {
                    this.getSignableVerifier().verify(signable);
                }
            }
            catch (SignatureException x) {
                throw new SignatureException(signable.toString() + ": " + x.getMessage(), (Throwable)x);
            }
            catch (GrantAccessDeniedException x) {
                throw new GrantAccessDeniedException(signable.toString() + ": " + x.getMessage(), (Throwable)x);
            }
            catch (ReadAccessDeniedException x) {
                throw new ReadAccessDeniedException(signable.toString() + ": " + x.getMessage(), (Throwable)x);
            }
            catch (WriteAccessDeniedException x) {
                throw new WriteAccessDeniedException(signable.toString() + ": " + x.getMessage(), (Throwable)x);
            }
        }
    }

    private SignableVerifier getSignableVerifier() {
        if (this.signableVerifier == null) {
            this.signableVerifier = new SignableVerifier((UserRepoKeyPublicKeyLookup)new UserRepoKeyPublicKeyLookupImpl(this.getTransactionOrFail()));
        }
        return this.signableVerifier;
    }

    private LocalRepository getLocalRepository() {
        if (this.localRepository == null) {
            LocalRepositoryDao localRepositoryDao = (LocalRepositoryDao)this.getTransactionOrFail().getDao(LocalRepositoryDao.class);
            this.localRepository = localRepositoryDao.getLocalRepositoryOrFail();
        }
        return this.localRepository;
    }

    private LocalRepositoryType getLocalRepositoryType() {
        if (this.localRepositoryType == null) {
            this.localRepositoryType = ((SsLocalRepository)this.getLocalRepository()).getLocalRepositoryType();
        }
        return this.localRepositoryType;
    }
}

