/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.filetree;

import co.codewizards.cloudstore.core.oio.File;
import org.subshare.gui.filetree.FileFileTreeItem;

public class NormalFileFileTreeItem
extends FileFileTreeItem {
    private static final long KIB = 1024L;
    private static final long MIB = 0x100000L;
    private static final long GIB = 0x40000000L;
    private static final long TIB = 0x10000000000L;

    public NormalFileFileTreeItem(File file) {
        super(file);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("file is a directory!");
        }
    }

    @Override
    protected void refresh() {
        super.refresh();
        this.updateSize();
    }

    private void updateSize() {
        this.sizeProperty().set((Object)this._getSize());
    }

    private String _getSize() {
        long length = this.getFile().length();
        if (length >= 0x10000000000L) {
            return String.format("%.1f TiB", (double)length / 1.099511627776E12);
        }
        if (length >= 0x40000000L) {
            return String.format("%.1f GiB", (double)length / 1.073741824E9);
        }
        if (length >= 0x100000L) {
            return String.format("%.1f MiB", (double)length / 1048576.0);
        }
        if (length >= 1024L) {
            return String.format("%.1f KiB", (double)length / 1024.0);
        }
        return String.format("%d B", length);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }
}

