/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.util;

import java.io.IOException;
import java.util.Objects;
import javafx.fxml.FXMLLoader;
import org.subshare.gui.util.ResourceBundleUtil;

public final class FxmlUtil {
    private FxmlUtil() {
    }

    private static FXMLLoader createFxmlLoader(Class<?> componentClass) {
        Objects.requireNonNull(componentClass, "componentClass");
        FXMLLoader fxmlLoader = new FXMLLoader(componentClass.getResource(componentClass.getSimpleName() + ".fxml"), ResourceBundleUtil.getMessages(componentClass));
        return fxmlLoader;
    }

    public static <T> void loadDynamicComponentFxml(Class<? super T> componentClass, T component) {
        Objects.requireNonNull(componentClass, "componentClass");
        Objects.requireNonNull(component, "component");
        FXMLLoader fxmlLoader = FxmlUtil.createFxmlLoader(componentClass);
        fxmlLoader.setRoot(component);
        fxmlLoader.setController(component);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

