/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.dto.ChangeSetDto;
import co.codewizards.cloudstore.core.dto.ConfigPropSetDto;
import co.codewizards.cloudstore.core.dto.DeleteModificationDto;
import co.codewizards.cloudstore.core.dto.DirectoryDto;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.dto.SymlinkDto;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.transport.CollisionException;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.persistence.LocalRepository;
import co.codewizards.cloudstore.local.persistence.LocalRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.jdo.PersistenceManager;
import org.bouncycastle.crypto.CipherParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.AbstractCryptree;
import org.subshare.core.AccessDeniedException;
import org.subshare.core.DataKey;
import org.subshare.core.FileDeletedException;
import org.subshare.core.GrantAccessDeniedException;
import org.subshare.core.LocalRepoStorage;
import org.subshare.core.LocalRepoStorageFactory;
import org.subshare.core.LocalRepoStorageFactoryRegistry;
import org.subshare.core.PermissionCollisionException;
import org.subshare.core.ReadAccessDeniedException;
import org.subshare.core.ReadUserIdentityAccessDeniedException;
import org.subshare.core.WriteAccessDeniedException;
import org.subshare.core.dto.CollisionDto;
import org.subshare.core.dto.CollisionPrivateDto;
import org.subshare.core.dto.CryptoChangeSetDto;
import org.subshare.core.dto.CryptoConfigPropSetDto;
import org.subshare.core.dto.CryptoKeyDeactivationDto;
import org.subshare.core.dto.CryptoKeyDto;
import org.subshare.core.dto.CryptoLinkDto;
import org.subshare.core.dto.CryptoRepoFileDto;
import org.subshare.core.dto.CurrentHistoCryptoRepoFileDto;
import org.subshare.core.dto.DeletedCollisionDto;
import org.subshare.core.dto.HistoCryptoRepoFileDto;
import org.subshare.core.dto.HistoFrameDto;
import org.subshare.core.dto.InvitationUserRepoKeyPublicKeyDto;
import org.subshare.core.dto.PermissionDto;
import org.subshare.core.dto.PermissionSetDto;
import org.subshare.core.dto.PermissionSetInheritanceDto;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.dto.PlainHistoCryptoRepoFileDto;
import org.subshare.core.dto.RepositoryOwnerDto;
import org.subshare.core.dto.SsNormalFileDto;
import org.subshare.core.dto.SsRepoFileDto;
import org.subshare.core.dto.SsSymlinkDto;
import org.subshare.core.dto.UserIdentityDto;
import org.subshare.core.dto.UserIdentityLinkDto;
import org.subshare.core.dto.UserIdentityPayloadDto;
import org.subshare.core.dto.UserRepoKeyPublicKeyDto;
import org.subshare.core.dto.UserRepoKeyPublicKeyReplacementRequestDeletionDto;
import org.subshare.core.dto.UserRepoKeyPublicKeyReplacementRequestDto;
import org.subshare.core.repair.RepairDeleteCollisionConfig;
import org.subshare.core.repo.local.PlainHistoCryptoRepoFileFilter;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.WriteProtected;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyPublicKeyDtoWithSignatureConverter;
import org.subshare.core.user.UserRepoKeyPublicKeyLookup;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.local.CryptreeContext;
import org.subshare.local.CryptreeNode;
import org.subshare.local.CryptreeNodeUtil;
import org.subshare.local.DuplicateCryptoRepoFileHandler;
import org.subshare.local.PlainCryptoKey;
import org.subshare.local.UpdatePlainHistoCryptoRepoFilesMarker;
import org.subshare.local.UserRepoKeyPublicKeyHelper;
import org.subshare.local.dto.CollisionDtoConverter;
import org.subshare.local.dto.CryptoConfigPropSetDtoConverter;
import org.subshare.local.dto.CryptoRepoFileDtoConverter;
import org.subshare.local.dto.CurrentHistoCryptoRepoFileDtoConverter;
import org.subshare.local.dto.DeletedCollisionDtoConverter;
import org.subshare.local.dto.HistoCryptoRepoFileDtoConverter;
import org.subshare.local.dto.HistoFrameDtoConverter;
import org.subshare.local.dto.UserIdentityDtoConverter;
import org.subshare.local.dto.UserIdentityLinkDtoConverter;
import org.subshare.local.dto.UserRepoKeyPublicKeyDtoConverter;
import org.subshare.local.dto.UserRepoKeyPublicKeyReplacementRequestDeletionDtoConverter;
import org.subshare.local.dto.UserRepoKeyPublicKeyReplacementRequestDtoConverter;
import org.subshare.local.persistence.AssignCryptoRepoFileRepoFileListener;
import org.subshare.local.persistence.Collision;
import org.subshare.local.persistence.CollisionDao;
import org.subshare.local.persistence.CryptoConfigPropSet;
import org.subshare.local.persistence.CryptoConfigPropSetDao;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoKeyDao;
import org.subshare.local.persistence.CryptoKeyDeactivation;
import org.subshare.local.persistence.CryptoLink;
import org.subshare.local.persistence.CryptoLinkDao;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.CurrentHistoCryptoRepoFile;
import org.subshare.local.persistence.CurrentHistoCryptoRepoFileDao;
import org.subshare.local.persistence.DeletedCollision;
import org.subshare.local.persistence.DeletedCollisionDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.HistoCryptoRepoFileDao;
import org.subshare.local.persistence.HistoFrame;
import org.subshare.local.persistence.HistoFrameDao;
import org.subshare.local.persistence.InvitationUserRepoKeyPublicKey;
import org.subshare.local.persistence.LastCryptoKeySyncFromRemoteRepo;
import org.subshare.local.persistence.LastCryptoKeySyncFromRemoteRepoDao;
import org.subshare.local.persistence.LastCryptoKeySyncToRemoteRepo;
import org.subshare.local.persistence.LastCryptoKeySyncToRemoteRepoDao;
import org.subshare.local.persistence.LocalRepositoryType;
import org.subshare.local.persistence.Permission;
import org.subshare.local.persistence.PermissionDao;
import org.subshare.local.persistence.PermissionSet;
import org.subshare.local.persistence.PermissionSetDao;
import org.subshare.local.persistence.PermissionSetInheritance;
import org.subshare.local.persistence.PermissionSetInheritanceDao;
import org.subshare.local.persistence.PlainHistoCryptoRepoFile;
import org.subshare.local.persistence.PlainHistoCryptoRepoFileDao;
import org.subshare.local.persistence.PreliminaryCollision;
import org.subshare.local.persistence.PreliminaryCollisionDao;
import org.subshare.local.persistence.PreliminaryDeletion;
import org.subshare.local.persistence.PreliminaryDeletionDao;
import org.subshare.local.persistence.RepositoryOwner;
import org.subshare.local.persistence.RepositoryOwnerDao;
import org.subshare.local.persistence.SignableDao;
import org.subshare.local.persistence.SsDirectory;
import org.subshare.local.persistence.SsLocalRepository;
import org.subshare.local.persistence.SsNormalFile;
import org.subshare.local.persistence.SsRemoteRepository;
import org.subshare.local.persistence.SsRepoFile;
import org.subshare.local.persistence.SsSymlink;
import org.subshare.local.persistence.UserIdentity;
import org.subshare.local.persistence.UserIdentityDao;
import org.subshare.local.persistence.UserIdentityLink;
import org.subshare.local.persistence.UserIdentityLinkDao;
import org.subshare.local.persistence.UserRepoKeyPublicKey;
import org.subshare.local.persistence.UserRepoKeyPublicKeyDao;
import org.subshare.local.persistence.UserRepoKeyPublicKeyLookupImpl;
import org.subshare.local.persistence.UserRepoKeyPublicKeyReplacementRequest;
import org.subshare.local.persistence.UserRepoKeyPublicKeyReplacementRequestDao;
import org.subshare.local.persistence.UserRepoKeyPublicKeyReplacementRequestDeletion;
import org.subshare.local.persistence.UserRepoKeyPublicKeyReplacementRequestDeletionDao;

public class CryptreeImpl
extends AbstractCryptree {
    private static final Logger logger = LoggerFactory.getLogger(CryptreeImpl.class);
    private UserRepoKeyPublicKeyLookupImpl userRepoKeyPublicKeyLookup;
    private UUID localRepositoryId;
    private UUID serverRepositoryId;
    private CryptreeContext cryptreeContext;
    private Uid rootCryptoRepoFileId;
    private LocalRepoStorage localRepoStorage;
    private static final UUID NULL_UUID = new UUID(0L, 0L);
    private static final AtomicLong nextModificationId = new AtomicLong();

    public UserRepoKeyPublicKeyLookup getUserRepoKeyPublicKeyLookup() {
        if (this.userRepoKeyPublicKeyLookup == null) {
            this.userRepoKeyPublicKeyLookup = new UserRepoKeyPublicKeyLookupImpl(this.getTransactionOrFail());
        }
        return this.userRepoKeyPublicKeyLookup;
    }

    public CryptoChangeSetDto createOrUpdateCryptoRepoFile(String localPath) {
        this.claimRepositoryOwnershipIfUnowned();
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        CryptoRepoFile cryptoRepoFile = cryptreeNode.getCryptoRepoFileOrCreate(true);
        CryptoChangeSetDto cryptoChangeSetDto = this.getCryptoChangeSetDto(cryptoRepoFile);
        return cryptoChangeSetDto;
    }

    public CurrentHistoCryptoRepoFileDto createCurrentHistoCryptoRepoFileDto(String localPath, boolean withHistoCryptoRepoFileDto) {
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        HistoCryptoRepoFile histoCryptoRepoFile = cryptreeNode.createHistoCryptoRepoFileIfNeeded();
        CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = cryptreeNode.getCurrentHistoCryptoRepoFile();
        CurrentHistoCryptoRepoFileDtoConverter chcrfDtoConverter = CurrentHistoCryptoRepoFileDtoConverter.create(this.getTransactionOrFail());
        CurrentHistoCryptoRepoFileDto result = chcrfDtoConverter.toCurrentHistoCryptoRepoFileDto(currentHistoCryptoRepoFile, withHistoCryptoRepoFileDto);
        if (withHistoCryptoRepoFileDto) {
            if (!result.getHistoCryptoRepoFileDto().getHistoCryptoRepoFileId().equals((Object)histoCryptoRepoFile.getHistoCryptoRepoFileId())) {
                throw new IllegalStateException("result.histoCryptoRepoFileDto.histoCryptoRepoFileId != histoCryptoRepoFile.histoCryptoRepoFileId");
            }
        } else if (!result.getHistoCryptoRepoFileId().equals((Object)histoCryptoRepoFile.getHistoCryptoRepoFileId())) {
            throw new IllegalStateException("result.histoCryptoRepoFileId != histoCryptoRepoFile.histoCryptoRepoFileId");
        }
        return result;
    }

    public CryptoChangeSetDto getCryptoChangeSetDtoOrFail(String localPath) {
        this.claimRepositoryOwnershipIfUnowned();
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        CryptoRepoFile cryptoRepoFile = cryptreeNode.getCryptoRepoFile();
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        CryptoChangeSetDto cryptoChangeSetDto = this.getCryptoChangeSetDto(cryptoRepoFile);
        return cryptoChangeSetDto;
    }

    public String getServerPath(String localPath) {
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        CryptoRepoFile cryptoRepoFile = cryptreeNode.getCryptoRepoFile();
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        return cryptoRepoFile.getServerPath();
    }

    public String getLocalPath(String serverPath) {
        Objects.requireNonNull(serverPath, "serverPath");
        if (StringUtil.isEmpty((String)serverPath)) {
            throw new IllegalArgumentException("serverPath is empty");
        }
        String cryptoRepoFileIdStr = serverPath;
        while (cryptoRepoFileIdStr.endsWith("/")) {
            cryptoRepoFileIdStr = cryptoRepoFileIdStr.substring(0, cryptoRepoFileIdStr.length() - 1);
        }
        int lastSlashIndex = cryptoRepoFileIdStr.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            cryptoRepoFileIdStr = cryptoRepoFileIdStr.substring(lastSlashIndex + 1);
        }
        Uid cryptoRepoFileId = new Uid(cryptoRepoFileIdStr);
        CryptoRepoFile cryptoRepoFile = this.getCryptreeContext().getCryptoRepoFileOrFail(cryptoRepoFileId);
        RepoFile repoFile = cryptoRepoFile.getRepoFile();
        String localPath = repoFile.getPath();
        return localPath;
    }

    public DataKey getDataKeyOrFail(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        return cryptreeNode.getDataKeyOrFail();
    }

    public DataKey getDataKeyOrFail(Uid cryptoKeyId) {
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(this.getRootCryptoRepoFileIdOrFail());
        return cryptreeNode.getDataKeyOrFail(cryptoKeyId);
    }

    protected CryptreeContext getCryptreeContext() {
        if (this.cryptreeContext == null) {
            this.cryptreeContext = new CryptreeContext(this.getUserRepoKeyRing(), this.getTransactionOrFail(), this.getLocalRepositoryIdOrFail(), this.getRemoteRepositoryIdOrFail(), this.getServerRepositoryIdOrFail(), this.getRemotePathPrefix(), this.isOnServer());
        }
        return this.cryptreeContext;
    }

    protected UUID getLocalRepositoryIdOrFail() {
        if (this.localRepositoryId == null) {
            LocalRepositoryDao localRepositoryDao = (LocalRepositoryDao)this.getTransactionOrFail().getDao(LocalRepositoryDao.class);
            LocalRepository localRepository = localRepositoryDao.getLocalRepositoryOrFail();
            this.localRepositoryId = localRepository.getRepositoryId();
        }
        return this.localRepositoryId;
    }

    protected UUID getServerRepositoryIdOrFail() {
        if (this.serverRepositoryId == null) {
            this.serverRepositoryId = this.isOnServer() ? this.getLocalRepositoryIdOrFail() : this.getRemoteRepositoryIdOrFail();
        }
        return this.serverRepositoryId;
    }

    public void prepareGetCryptoChangeSetDtoWithCryptoRepoFiles(Long lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced) {
        this.claimRepositoryOwnershipIfUnowned();
        this.processUserRepoKeyPublicKeyReplacementRequests();
        this.createMissingUserIdentities();
        this.repairDeleteCollisionsIfNeeded();
        LocalRepository localRepository = ((LocalRepositoryDao)this.getTransactionOrFail().getDao(LocalRepositoryDao.class)).getLocalRepositoryOrFail();
        LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo = this.getLastCryptoKeySyncToRemoteRepo();
        if (this.getRootCryptoRepoFileId() == null && !this.isOnServer()) {
            this.createOrUpdateCryptoRepoFile("");
        }
        if (lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced != null) {
            boolean resyncMode;
            boolean bl = resyncMode = lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced.longValue() != lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced();
            if (resyncMode) {
                lastCryptoKeySyncToRemoteRepo.setResyncMode(true);
                logger.warn("prepareGetCryptoChangeSetDtoWithCryptoRepoFiles: Enabling resyncMode! lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced={} overwrites lastCryptoKeySyncToRemoteRepo.localRepositoryRevisionSynced={}", (Object)lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced, (Object)lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
            } else if (lastCryptoKeySyncToRemoteRepo.isResyncMode()) {
                logger.warn("prepareGetCryptoChangeSetDtoWithCryptoRepoFiles: resyncMode still active! lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced={}", (Object)lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced);
            }
            lastCryptoKeySyncToRemoteRepo.setLocalRepositoryRevisionSynced(lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced);
        }
        lastCryptoKeySyncToRemoteRepo.setLocalRepositoryRevisionInProgress(localRepository.getRevision());
        this.enactPermissionRevocationsOfChangedPermissionsIfNeededAndPossible(lastCryptoKeySyncToRemoteRepo);
        this.enactPermissionSetInheritanceRevocationsOfChangedPermissionSetInheritancesIfNeededAndPossible(lastCryptoKeySyncToRemoteRepo);
    }

    public CryptoChangeSetDto getCryptoChangeSetDtoWithCryptoRepoFiles(Long lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced) {
        LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo = this.getLastCryptoKeySyncToRemoteRepo();
        CryptoChangeSetDto cryptoChangeSetDto = new CryptoChangeSetDto();
        this.populateChangedCryptoRepoFileDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateCryptoChangeSetDtoWithAllButCryptoRepoFiles(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        logger.trace("getCryptoChangeSetDtoWithCryptoRepoFiles(): {}", (Object)cryptoChangeSetDto);
        return cryptoChangeSetDto;
    }

    private void createMissingUserIdentities() {
        if (this.isOnServer()) {
            return;
        }
        UserRepoKeyPublicKeyHelper userRepoKeyPublicKeyHelper = new UserRepoKeyPublicKeyHelper(this.getCryptreeContext());
        userRepoKeyPublicKeyHelper.createMissingUserIdentities();
    }

    public void updateLastCryptoKeySyncToRemoteRepo() {
        LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo = this.getLastCryptoKeySyncToRemoteRepo();
        long localRepositoryRevisionInProgress = lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionInProgress();
        if (localRepositoryRevisionInProgress < 0L) {
            throw new IllegalStateException("localRepositoryRevisionInProgress < 0 :: There is no CryptoKey-sync in progress!");
        }
        lastCryptoKeySyncToRemoteRepo.setLocalRepositoryRevisionSynced(localRepositoryRevisionInProgress);
        lastCryptoKeySyncToRemoteRepo.setLocalRepositoryRevisionInProgress(-1L);
        lastCryptoKeySyncToRemoteRepo.setResyncMode(false);
    }

    public void putCryptoChangeSetDto(CryptoChangeSetDto cryptoChangeSetDto) {
        RepositoryOwnerDto repositoryOwnerDto;
        Objects.requireNonNull(cryptoChangeSetDto, "cryptoChangeSetDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        AssignCryptoRepoFileRepoFileListener acrfrfl = (AssignCryptoRepoFileRepoFileListener)((Object)transaction.getContextObject(AssignCryptoRepoFileRepoFileListener.class));
        Objects.requireNonNull(acrfrfl, "assignCryptoRepoFileRepoFileListener");
        boolean lastMultiPart = false;
        if (cryptoChangeSetDto.getMultiPartCount() > 0) {
            lastMultiPart = cryptoChangeSetDto.getMultiPartIndex() + 1 == cryptoChangeSetDto.getMultiPartCount();
            acrfrfl.setForced(lastMultiPart);
            acrfrfl.setDisabled(!lastMultiPart);
        }
        if (cryptoChangeSetDto.getRevision() >= 0L) {
            this.setLastCryptoKeySyncFromRemoteRepoRemoteRepositoryRevisionSynced(cryptoChangeSetDto.getRevision());
        }
        HashMap<CryptoRepoFileDto, CryptoRepoFile> cryptoRepoFileDto2CryptoRepoFile = new HashMap<CryptoRepoFileDto, CryptoRepoFile>();
        HashMap<Uid, CryptoKey> cryptoKeyId2CryptoKey = new HashMap<Uid, CryptoKey>();
        for (UserRepoKeyPublicKeyDto userRepoKeyPublicKeyDto : cryptoChangeSetDto.getUserRepoKeyPublicKeyDtos()) {
            this.putUserRepoKeyPublicKeyDto(userRepoKeyPublicKeyDto);
        }
        for (CryptoRepoFileDto cryptoRepoFileDto : this.sortCryptoRepoFileDtos(cryptoChangeSetDto.getCryptoRepoFileDtos())) {
            cryptoRepoFileDto2CryptoRepoFile.put(cryptoRepoFileDto, this.putCryptoRepoFileDto(cryptoRepoFileDto));
        }
        for (CryptoKeyDto cryptoKeyDto : cryptoChangeSetDto.getCryptoKeyDtos()) {
            CryptoKey cryptoKey = this.putCryptoKeyDto(cryptoKeyDto);
            cryptoKeyId2CryptoKey.put(cryptoKey.getCryptoKeyId(), cryptoKey);
        }
        for (CryptoLinkDto cryptoLinkDto : cryptoChangeSetDto.getCryptoLinkDtos()) {
            this.putCryptoLinkDto(cryptoLinkDto);
        }
        for (Map.Entry entry : cryptoRepoFileDto2CryptoRepoFile.entrySet()) {
            Uid cryptoKeyId = ((CryptoRepoFileDto)entry.getKey()).getCryptoKeyId();
            CryptoRepoFile cryptoRepoFile = (CryptoRepoFile)((Object)entry.getValue());
            if (cryptoRepoFile.getCryptoKey() != null && cryptoKeyId.equals((Object)cryptoRepoFile.getCryptoKey().getCryptoKeyId())) continue;
            CryptoKey cryptoKey = (CryptoKey)((Object)cryptoKeyId2CryptoKey.get(cryptoKeyId));
            if (cryptoKey == null) {
                throw new IllegalStateException(String.format("The CryptoKey with cryptoKeyId=%s was neither found in the DB nor is it contained in this CryptoChangeSetDto!", cryptoKeyId));
            }
            cryptoRepoFile.setCryptoKey(cryptoKey);
        }
        if (this.isOnServer()) {
            for (CryptoRepoFile cryptoRepoFile : cryptoRepoFileDto2CryptoRepoFile.values()) {
                if (cryptoRepoFile.getDeleted() == null) continue;
                RepoFile repoFile = cryptoRepoFile.getRepoFile();
                if (repoFile != null) {
                    this.deleteRepoFileWithAllChildrenRecursively(repoFile);
                    continue;
                }
                logger.warn("putCryptoChangeSetDto: repoFile == null!!! {}", (Object)cryptoRepoFile);
            }
        }
        if (!this.isOnServer()) {
            for (CryptoRepoFile cryptoRepoFile : cryptoRepoFileDto2CryptoRepoFile.values()) {
                RepoFileDto decryptedRepoFileDto;
                try {
                    decryptedRepoFileDto = this.getDecryptedRepoFileDtoOrFail(cryptoRepoFile.getCryptoRepoFileId());
                }
                catch (AccessDeniedException x) {
                    continue;
                }
                cryptoRepoFile.setLocalName(decryptedRepoFileDto.getName());
            }
        }
        if ((repositoryOwnerDto = cryptoChangeSetDto.getRepositoryOwnerDto()) == null) {
            this.claimRepositoryOwnershipIfUnowned();
        } else {
            this.putRepositoryOwnerDto(repositoryOwnerDto);
        }
        for (PermissionSetDto permissionSetDto : cryptoChangeSetDto.getPermissionSetDtos()) {
            this.putPermissionSetDto(permissionSetDto);
        }
        for (PermissionDto permissionDto : cryptoChangeSetDto.getPermissionDtos()) {
            this.putPermissionDto(permissionDto);
        }
        for (UserRepoKeyPublicKeyReplacementRequestDto requestDto : cryptoChangeSetDto.getUserRepoKeyPublicKeyReplacementRequestDtos()) {
            this.putUserRepoKeyPublicKeyReplacementRequestDto(requestDto);
        }
        for (UserIdentityDto userIdentityDto : cryptoChangeSetDto.getUserIdentityDtos()) {
            this.putUserIdentityDto(userIdentityDto);
        }
        for (UserIdentityLinkDto userIdentityLinkDto : cryptoChangeSetDto.getUserIdentityLinkDtos()) {
            this.putUserIdentityLinkDto(userIdentityLinkDto);
        }
        transaction.flush();
        for (PermissionSetInheritanceDto permissionSetInheritanceDto : cryptoChangeSetDto.getPermissionSetInheritanceDtos()) {
            this.putPermissionSetInheritanceDto(permissionSetInheritanceDto);
        }
        transaction.flush();
        HistoCryptoRepoFileDtoConverter histoCryptoRepoFileDtoConverter = HistoCryptoRepoFileDtoConverter.create(this.getTransactionOrFail());
        HashMap<HistoCryptoRepoFileDto, HistoCryptoRepoFile> histoCryptoRepoFileDto2HistoCryptoRepoFile = new HashMap<HistoCryptoRepoFileDto, HistoCryptoRepoFile>();
        for (HistoFrameDto histoFrameDto : cryptoChangeSetDto.getHistoFrameDtos()) {
            this.putHistoFrameDto(histoFrameDto);
        }
        this.putHistoCryptoRepoFileDtos(histoCryptoRepoFileDtoConverter, histoCryptoRepoFileDto2HistoCryptoRepoFile, cryptoChangeSetDto.getHistoCryptoRepoFileDtos());
        HashSet<Uid> dirtyPlainHistoCryptoRepoFileIds = new HashSet<Uid>();
        ArrayList<Collision> collisions = new ArrayList<Collision>();
        for (CollisionDto collisionDto : cryptoChangeSetDto.getCollisionDtos()) {
            collisions.add(this.putCollisionDto(collisionDto));
            dirtyPlainHistoCryptoRepoFileIds.add(collisionDto.getHistoCryptoRepoFileId1());
            dirtyPlainHistoCryptoRepoFileIds.add(collisionDto.getHistoCryptoRepoFileId2());
        }
        dirtyPlainHistoCryptoRepoFileIds.remove(null);
        for (Object histoCryptoRepoFile : histoCryptoRepoFileDto2HistoCryptoRepoFile.values()) {
            dirtyPlainHistoCryptoRepoFileIds.add(((HistoCryptoRepoFile)((Object)histoCryptoRepoFile)).getHistoCryptoRepoFileId());
        }
        CurrentHistoCryptoRepoFileDtoConverter currentHistoCryptoRepoFileDtoConverter = CurrentHistoCryptoRepoFileDtoConverter.create(transaction);
        for (CurrentHistoCryptoRepoFileDto currentHistoCryptoRepoFileDto : cryptoChangeSetDto.getCurrentHistoCryptoRepoFileDtos()) {
            CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = currentHistoCryptoRepoFileDtoConverter.putCurrentHistoCryptoRepoFile(currentHistoCryptoRepoFileDto);
            currentHistoCryptoRepoFile.setLastSyncFromRepositoryId(this.getRemoteRepositoryIdOrFail());
        }
        if (!this.isOnServer()) {
            SsLocalRepository localRepository = (SsLocalRepository)((LocalRepositoryDao)transaction.getDao(LocalRepositoryDao.class)).getLocalRepositoryOrFail();
            if (localRepository.getLocalRepositoryType() == LocalRepositoryType.CLIENT_META_ONLY) {
                HashMap<CryptoRepoFile, RepoFileDto> cryptoRepoFile2DecryptedRepoFileDto = new HashMap<CryptoRepoFile, RepoFileDto>();
                for (HistoCryptoRepoFile histoCryptoRepoFile : histoCryptoRepoFileDto2HistoCryptoRepoFile.values()) {
                    RepoFileDto decryptedRepoFileDto;
                    if (histoCryptoRepoFile.getCryptoRepoFile().getDeleted() != null) continue;
                    try {
                        decryptedRepoFileDto = this.getDecryptedRepoFileOnServerDtoOrFail(histoCryptoRepoFile.getCryptoRepoFile().getCryptoRepoFileId());
                    }
                    catch (AccessDeniedException | FileDeletedException x) {
                        continue;
                    }
                    cryptoRepoFile2DecryptedRepoFileDto.put(histoCryptoRepoFile.getCryptoRepoFile(), decryptedRepoFileDto);
                }
                this.putDecryptedRepoFiles(cryptoRepoFile2DecryptedRepoFileDto);
            } else {
                HistoCryptoRepoFileDao histoCryptoRepoFileDao = (HistoCryptoRepoFileDao)((Object)this.getTransactionOrFail().getDao(HistoCryptoRepoFileDao.class));
                for (Uid histoCryptoRepoFileId : dirtyPlainHistoCryptoRepoFileIds) {
                    HistoCryptoRepoFile histoCryptoRepoFile = histoCryptoRepoFileDao.getHistoCryptoRepoFileOrFail(histoCryptoRepoFileId);
                    Uid cryptoRepoFileId = histoCryptoRepoFile.getCryptoRepoFile().getCryptoRepoFileId();
                    CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
                    cryptreeNode.updatePlainHistoCryptoRepoFile(histoCryptoRepoFile);
                }
                for (Collision collision : collisions) {
                    Uid cryptoRepoFileId = collision.getHistoCryptoRepoFile1().getCryptoRepoFile().getCryptoRepoFileId();
                    CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
                    cryptreeNode.updateCollisionPrivate(collision);
                }
            }
        }
        for (DeletedCollisionDto deletedCollisionDto : cryptoChangeSetDto.getDeletedCollisionDtos()) {
            this.putDeletedCollisionDto(deletedCollisionDto);
        }
        transaction.flush();
        this.putCryptoConfigPropSetDtos(cryptoChangeSetDto.getCryptoConfigPropSetDtos());
        transaction.flush();
        if (cryptoChangeSetDto.getMultiPartCount() < 0 || lastMultiPart) {
            this.processUserRepoKeyPublicKeyReplacementRequests();
        }
        for (UserRepoKeyPublicKeyReplacementRequestDeletionDto requestDeletionDto : cryptoChangeSetDto.getUserRepoKeyPublicKeyReplacementRequestDeletionDtos()) {
            this.putUserRepoKeyPublicKeyReplacementRequestDeletionDto(requestDeletionDto);
        }
        if ((cryptoChangeSetDto.getMultiPartCount() < 0 || lastMultiPart) && !this.isOnServer()) {
            new UserRepoKeyPublicKeyHelper(this.getCryptreeContext()).updateUserRepoKeyRingFromUserIdentities();
        }
        this.getCryptreeContext().getUserRegistry().writeIfNeeded();
    }

    private void putDeletedCollisionDto(DeletedCollisionDto deletedCollisionDto) {
        Objects.requireNonNull(deletedCollisionDto, "deletedCollisionDto");
        LocalRepoTransaction tx = this.getTransactionOrFail();
        DeletedCollisionDtoConverter dcDtoConverter = DeletedCollisionDtoConverter.create(tx);
        CollisionDao cDao = (CollisionDao)((Object)tx.getDao(CollisionDao.class));
        DeletedCollision deletedCollision = dcDtoConverter.putDeletedCollisionDto(deletedCollisionDto);
        Collision collision = cDao.getCollision(deletedCollision.getCollisionId());
        if (collision != null) {
            cDao.deletePersistent(collision);
        }
    }

    protected List<CryptoRepoFileDto> sortCryptoRepoFileDtos(List<CryptoRepoFileDto> cryptoRepoFileDtos) {
        Objects.requireNonNull(cryptoRepoFileDtos, "cryptoRepoFileDtos");
        HashMap<Uid, CryptoRepoFileDto> cryptoRepoFileId2CryptoRepoFileDto = new HashMap<Uid, CryptoRepoFileDto>(cryptoRepoFileDtos.size());
        for (CryptoRepoFileDto cryptoRepoFileDto : cryptoRepoFileDtos) {
            Uid cryptoRepoFileId = Objects.requireNonNull(cryptoRepoFileDto.getCryptoRepoFileId(), "cryptoRepoFileDto.cryptoRepoFileId");
            CryptoRepoFileDto old = cryptoRepoFileId2CryptoRepoFileDto.put(cryptoRepoFileId, cryptoRepoFileDto);
            if (old == null) continue;
            throw new IllegalArgumentException("cryptoRepoFileDtos contains duplicate cryptoRepoFileDto.cryptoRepoFileId: " + cryptoRepoFileId);
        }
        ArrayList<CryptoRepoFileDto> result = new ArrayList<CryptoRepoFileDto>(cryptoRepoFileDtos.size());
        HashSet<Uid> resultCryptoRepoFileIds = new HashSet<Uid>(cryptoRepoFileDtos.size());
        for (CryptoRepoFileDto cryptoRepoFileDto : cryptoRepoFileDtos) {
            this.sortCryptoRepoFileDtos_addCryptoRepoFileDtoWithParentsFirst(result, resultCryptoRepoFileIds, cryptoRepoFileDto, cryptoRepoFileId2CryptoRepoFileDto);
        }
        if (result.size() != cryptoRepoFileDtos.size()) {
            throw new IllegalStateException(String.format("result.size != cryptoRepoFileDtos.size :: %s != %s", result.size(), cryptoRepoFileDtos.size()));
        }
        return result;
    }

    protected void sortCryptoRepoFileDtos_addCryptoRepoFileDtoWithParentsFirst(List<CryptoRepoFileDto> result, Set<Uid> resultCryptoRepoFileIds, CryptoRepoFileDto cryptoRepoFileDto, Map<Uid, CryptoRepoFileDto> cryptoRepoFileId2CryptoRepoFileDto) {
        CryptoRepoFileDto parentCryptoRepoFileDto;
        Objects.requireNonNull(result, "result");
        Objects.requireNonNull(resultCryptoRepoFileIds, "resultCryptoRepoFileIds");
        Objects.requireNonNull(cryptoRepoFileDto, "cryptoRepoFileDto");
        Objects.requireNonNull(cryptoRepoFileId2CryptoRepoFileDto, "cryptoRepoFileId2CryptoRepoFileDto");
        Uid cryptoRepoFileId = Objects.requireNonNull(cryptoRepoFileDto.getCryptoRepoFileId(), "cryptoRepoFileDto.cryptoRepoFileId");
        if (resultCryptoRepoFileIds.contains(cryptoRepoFileId)) {
            return;
        }
        Uid parentCryptoRepoFileId = cryptoRepoFileDto.getParentCryptoRepoFileId();
        if (!resultCryptoRepoFileIds.contains(parentCryptoRepoFileId) && (parentCryptoRepoFileDto = cryptoRepoFileId2CryptoRepoFileDto.get(parentCryptoRepoFileId)) != null) {
            logger.info("sortCryptoRepoFileDtos_addCryptoRepoFileDtoWithParentsFirst: parent is not yet in result, but part of the CryptoChangeSet -- adding parent to result first: cryptoRepoFileId={}, parentCryptoRepoFileId={}", (Object)cryptoRepoFileId, (Object)parentCryptoRepoFileId);
            this.sortCryptoRepoFileDtos_addCryptoRepoFileDtoWithParentsFirst(result, resultCryptoRepoFileIds, parentCryptoRepoFileDto, cryptoRepoFileId2CryptoRepoFileDto);
        }
        result.add(cryptoRepoFileDto);
        resultCryptoRepoFileIds.add(cryptoRepoFileId);
    }

    public ConfigPropSetDto getParentConfigPropSetDtoIfNeeded() {
        String remotePathPrefix = this.getRemotePathPrefix();
        if (remotePathPrefix == null) {
            throw new IllegalStateException("This method should not be invoked on the server!");
        }
        if (remotePathPrefix.isEmpty()) {
            return null;
        }
        Uid id = this.getCryptreeContext().getCryptoRepoFileIdForRemotePathPrefixOrFail();
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(id);
        return cryptreeNode.getParentConfigPropSetDtoIfNeeded();
    }

    private void putHistoCryptoRepoFileDtos(HistoCryptoRepoFileDtoConverter histoCryptoRepoFileDtoConverter, Map<HistoCryptoRepoFileDto, HistoCryptoRepoFile> histoCryptoRepoFileDto2HistoCryptoRepoFile, List<HistoCryptoRepoFileDto> histoCryptoRepoFileDtos) {
        HashMap<Uid, HistoCryptoRepoFileDto> histoCryptoRepoFileId2HistoCryptoRepoFileDto = new HashMap<Uid, HistoCryptoRepoFileDto>(histoCryptoRepoFileDtos.size());
        for (HistoCryptoRepoFileDto histoCryptoRepoFileDto : histoCryptoRepoFileDtos) {
            histoCryptoRepoFileId2HistoCryptoRepoFileDto.put(histoCryptoRepoFileDto.getHistoCryptoRepoFileId(), histoCryptoRepoFileDto);
        }
        this.putHistoCryptoRepoFileDtos(histoCryptoRepoFileDtoConverter, histoCryptoRepoFileDto2HistoCryptoRepoFile, histoCryptoRepoFileId2HistoCryptoRepoFileDto);
    }

    private void putHistoCryptoRepoFileDtos(HistoCryptoRepoFileDtoConverter histoCryptoRepoFileDtoConverter, Map<HistoCryptoRepoFileDto, HistoCryptoRepoFile> histoCryptoRepoFileDto2HistoCryptoRepoFile, Map<Uid, HistoCryptoRepoFileDto> histoCryptoRepoFileId2HistoCryptoRepoFileDto) {
        for (HistoCryptoRepoFileDto histoCryptoRepoFileDto : histoCryptoRepoFileId2HistoCryptoRepoFileDto.values()) {
            this.putHistoCryptoRepoFileDto(histoCryptoRepoFileDtoConverter, histoCryptoRepoFileDto2HistoCryptoRepoFile, histoCryptoRepoFileId2HistoCryptoRepoFileDto, histoCryptoRepoFileDto);
        }
    }

    private void putHistoCryptoRepoFileDto(HistoCryptoRepoFileDtoConverter histoCryptoRepoFileDtoConverter, Map<HistoCryptoRepoFileDto, HistoCryptoRepoFile> histoCryptoRepoFileDto2HistoCryptoRepoFile, Map<Uid, HistoCryptoRepoFileDto> histoCryptoRepoFileId2HistoCryptoRepoFileDto, HistoCryptoRepoFileDto histoCryptoRepoFileDto) {
        HistoCryptoRepoFileDto previousHistoCryptoRepoFileDto;
        HistoCryptoRepoFile histoCryptoRepoFile = histoCryptoRepoFileDto2HistoCryptoRepoFile.get(histoCryptoRepoFileDto);
        if (histoCryptoRepoFile != null) {
            return;
        }
        Uid previousHistoCryptoRepoFileId = histoCryptoRepoFileDto.getPreviousHistoCryptoRepoFileId();
        if (previousHistoCryptoRepoFileId != null && (previousHistoCryptoRepoFileDto = histoCryptoRepoFileId2HistoCryptoRepoFileDto.get(previousHistoCryptoRepoFileId)) != null) {
            this.putHistoCryptoRepoFileDto(histoCryptoRepoFileDtoConverter, histoCryptoRepoFileDto2HistoCryptoRepoFile, histoCryptoRepoFileId2HistoCryptoRepoFileDto, previousHistoCryptoRepoFileDto);
        }
        histoCryptoRepoFile = histoCryptoRepoFileDtoConverter.putHistoCryptoRepoFile(histoCryptoRepoFileDto);
        histoCryptoRepoFile.setLastSyncFromRepositoryId(this.getRemoteRepositoryId());
        histoCryptoRepoFileDto2HistoCryptoRepoFile.put(histoCryptoRepoFileDto, histoCryptoRepoFile);
    }

    private void putDecryptedRepoFiles(Map<CryptoRepoFile, RepoFileDto> cryptoRepoFile2DecryptedRepoFileDto) {
        Objects.requireNonNull(cryptoRepoFile2DecryptedRepoFileDto, "cryptoRepoFile2DecryptedRepoFileDto");
        HashMap<CryptoRepoFile, RepoFileDto> cache = new HashMap<CryptoRepoFile, RepoFileDto>(cryptoRepoFile2DecryptedRepoFileDto);
        for (Map.Entry<CryptoRepoFile, RepoFileDto> me : cryptoRepoFile2DecryptedRepoFileDto.entrySet()) {
            this.putDecryptedRepoFile(cache, me.getKey(), me.getValue());
        }
    }

    private RepoFile putDecryptedRepoFile(Map<CryptoRepoFile, RepoFileDto> cryptoRepoFile2DecryptedRepoFileDto, CryptoRepoFile cryptoRepoFile, RepoFileDto decryptedRepoFileDto) {
        Objects.requireNonNull(cryptoRepoFile2DecryptedRepoFileDto, "cryptoRepoFile2DecryptedRepoFileDto");
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        Objects.requireNonNull(decryptedRepoFileDto, "decryptedRepoFileDto");
        if (cryptoRepoFile.getDeleted() != null) {
            logger.info("putDecryptedRepoFile: Skipping deleted {}", (Object)cryptoRepoFile);
            return null;
        }
        RepoFile decryptedRepoFile = cryptoRepoFile.getRepoFile();
        if (decryptedRepoFile == null) {
            CryptoRepoFile parentCryptoRepoFile = cryptoRepoFile.getParent();
            RepoFile parentRepoFile = null;
            if (parentCryptoRepoFile != null && (parentRepoFile = parentCryptoRepoFile.getRepoFile()) == null) {
                RepoFileDto parentRepoFileDto = cryptoRepoFile2DecryptedRepoFileDto.get((Object)parentCryptoRepoFile);
                if (parentRepoFileDto == null) {
                    parentRepoFileDto = this.getDecryptedRepoFileDtoOrFail(parentCryptoRepoFile.getCryptoRepoFileId());
                }
                if ((parentRepoFile = this.putDecryptedRepoFile(cryptoRepoFile2DecryptedRepoFileDto, parentCryptoRepoFile, parentRepoFileDto)) == null) {
                    logger.warn("putDecryptedRepoFile: Skipping because parentRepoFile == null! {}", (Object)cryptoRepoFile);
                    return null;
                }
            }
            decryptedRepoFile = this.putDecryptedRepoFile(cryptoRepoFile, decryptedRepoFileDto, parentRepoFile);
        }
        return decryptedRepoFile;
    }

    private RepoFile putDecryptedRepoFile(CryptoRepoFile cryptoRepoFile, RepoFileDto decryptedRepoFileDto, RepoFile parentRepoFile) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        Objects.requireNonNull(decryptedRepoFileDto, "decryptedRepoFileDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
        Object result = repoFileDao.getChildRepoFile(parentRepoFile, decryptedRepoFileDto.getName());
        if (result == null) {
            if (decryptedRepoFileDto instanceof NormalFileDto) {
                SsNormalFileDto normalFileDto = (SsNormalFileDto)decryptedRepoFileDto;
                SsNormalFile normalFile = (SsNormalFile)ObjectFactoryUtil.createObject(SsNormalFile.class);
                result = normalFile;
                normalFile.setLength(normalFileDto.getLength());
                normalFile.setLengthWithPadding(normalFileDto.getLengthWithPadding());
                normalFile.setSha1(normalFileDto.getSha1());
            } else if (decryptedRepoFileDto instanceof DirectoryDto) {
                SsDirectory directory = (SsDirectory)ObjectFactoryUtil.createObject(SsDirectory.class);
                result = directory;
            } else if (decryptedRepoFileDto instanceof SymlinkDto) {
                SsSymlinkDto symlinkDto = (SsSymlinkDto)decryptedRepoFileDto;
                SsSymlink symlink = (SsSymlink)ObjectFactoryUtil.createObject(SsSymlink.class);
                result = symlink;
                symlink.setTarget(symlinkDto.getTarget());
            } else {
                throw new IllegalStateException("Unknown RepoFileDto type: " + decryptedRepoFileDto);
            }
            result.setName(decryptedRepoFileDto.getName());
            result.setLastModified(decryptedRepoFileDto.getLastModified());
            result.setParent(parentRepoFile);
            result.setLastSyncFromRepositoryId(this.getServerRepositoryIdOrFail());
            ((SsRepoFile)result).setSignature(((SsRepoFileDto)decryptedRepoFileDto).getSignature());
        } else {
            CryptoRepoFileDao crfDao = (CryptoRepoFileDao)((Object)transaction.getDao(CryptoRepoFileDao.class));
            CryptoRepoFile cryptoRepoFile2 = crfDao.getCryptoRepoFile((RepoFile)result);
            if (cryptoRepoFile2 != null && !cryptoRepoFile.equals((Object)cryptoRepoFile2) && cryptoRepoFile2.getDeleted() != null) {
                logger.warn("putDecryptedRepoFile: RepoFile is currently associated with another CryptoRepoFile, which is already marked as deleted. Dissociating it. {}, {}, {}", new Object[]{result, cryptoRepoFile, cryptoRepoFile2});
                cryptoRepoFile2.setRepoFile(null);
                transaction.flush();
            }
        }
        cryptoRepoFile.setRepoFile((RepoFile)result);
        transaction.flush();
        return result;
    }

    private void processUserRepoKeyPublicKeyReplacementRequests() {
        if (this.isOnServer()) {
            return;
        }
        if (this.getLocalRepoStorage().isMetaOnly()) {
            return;
        }
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        UserRepoKeyPublicKeyReplacementRequestDao requestDao = (UserRepoKeyPublicKeyReplacementRequestDao)((Object)transaction.getDao(UserRepoKeyPublicKeyReplacementRequestDao.class));
        for (UserRepoKeyPublicKeyReplacementRequest request : requestDao.getObjects()) {
            this.getCryptreeContext().signableVerifier.verify((Signable)request);
            if (!request.getOldKey().getUserRepoKeyId().equals((Object)request.getSignature().getSigningUserRepoKeyId())) {
                throw new IllegalStateException("request.oldKey.userRepoKeyId != request.signature.signingUserRepoKeyId");
            }
            UserRepoKey newUserRepoKey = this.getCryptreeContext().userRepoKeyRing.getUserRepoKey(request.getNewKey().getUserRepoKeyId());
            if (newUserRepoKey != null) {
                this.processUserRepoKeyPublicKeyReplacementRequestAsInvitedUser(request);
                continue;
            }
            UserRepoKey oldKeySigningUserRepoKey = this.getCryptreeContext().userRepoKeyRing.getUserRepoKey(request.getOldKey().getSignature().getSigningUserRepoKeyId());
            if (oldKeySigningUserRepoKey == null) continue;
            this.processUserRepoKeyPublicKeyReplacementRequestAsInvitingUser(request);
        }
        transaction.flush();
    }

    private void processUserRepoKeyPublicKeyReplacementRequestAsInvitedUser(UserRepoKeyPublicKeyReplacementRequest request) {
        logger.info("processUserRepoKeyPublicKeyReplacementRequestAsInvitedUser: {}", (Object)request);
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        UserRepoKey newUserRepoKey = this.getCryptreeContext().userRepoKeyRing.getUserRepoKeyOrFail(request.getNewKey().getUserRepoKeyId());
        UserRepoKey oldUserRepoKey = this.getCryptreeContext().userRepoKeyRing.getUserRepoKey(request.getOldKey().getUserRepoKeyId());
        if (oldUserRepoKey == null) {
            logger.warn("processUserRepoKeyPublicKeyReplacementRequestAsInvitedUser: userRepoKeyId == {} unknown! Probably already processed?!", (Object)request.getOldKey().getUserRepoKeyId());
            return;
        }
        CryptoLinkDao cryptoLinkDao = (CryptoLinkDao)((Object)transaction.getDao(CryptoLinkDao.class));
        PermissionDao permissionDao = (PermissionDao)((Object)transaction.getDao(PermissionDao.class));
        Collection<CryptoLink> cryptoLinks = cryptoLinkDao.getCryptoLinks(request.getOldKey());
        for (CryptoLink cryptoLink : cryptoLinks) {
            byte[] plainToCryptoKeyData = CryptreeNodeUtil.decrypt(cryptoLink.getToCryptoKeyData(), (CipherParameters)oldUserRepoKey.getKeyPair().getPrivate());
            byte[] newToCryptoKeyData = CryptreeNodeUtil.encrypt(plainToCryptoKeyData, (CipherParameters)newUserRepoKey.getKeyPair().getPublic());
            cryptoLink.setToCryptoKeyData(newToCryptoKeyData);
            cryptoLink.setFromUserRepoKeyPublicKey(request.getNewKey());
            cryptoLink.setLastSyncFromRepositoryId(null);
            this.getCryptreeContext().getSignableSigner(oldUserRepoKey).sign((Signable)cryptoLink);
        }
        Collection<Permission> permissions = permissionDao.getPermissions(request.getOldKey());
        for (Permission permission : permissions) {
            permission.setUserRepoKeyPublicKey(request.getNewKey());
            this.getCryptreeContext().getSignableSigner(oldUserRepoKey).sign((Signable)permission);
        }
    }

    private void processUserRepoKeyPublicKeyReplacementRequestAsInvitingUser(UserRepoKeyPublicKeyReplacementRequest request) {
        logger.info("processUserRepoKeyPublicKeyReplacementRequestAsInvitingUser: {}", (Object)request);
        UserRepoKey oldKeySigningUserRepoKey = this.getCryptreeContext().userRepoKeyRing.getUserRepoKeyOrFail(request.getOldKey().getSignature().getSigningUserRepoKeyId());
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        UserRepoKeyPublicKeyReplacementRequestDeletionDao requestDeletionDao = (UserRepoKeyPublicKeyReplacementRequestDeletionDao)((Object)transaction.getDao(UserRepoKeyPublicKeyReplacementRequestDeletionDao.class));
        CryptoLinkDao cryptoLinkDao = (CryptoLinkDao)((Object)transaction.getDao(CryptoLinkDao.class));
        PermissionDao permissionDao = (PermissionDao)((Object)transaction.getDao(PermissionDao.class));
        Collection<CryptoLink> cryptoLinks = cryptoLinkDao.getCryptoLinks(request.getOldKey());
        for (CryptoLink cryptoLink : cryptoLinks) {
            CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoLink.getToCryptoKey().getCryptoRepoFile().getCryptoRepoFileId());
            PlainCryptoKey plainCryptoKey = cryptreeNode.getPlainCryptoKeyForDecrypting(cryptoLink.getToCryptoKey());
            Objects.requireNonNull(plainCryptoKey, "plainCryptoKey[cryptoKeyId=" + cryptoLink.getToCryptoKey().getCryptoKeyId() + "]");
            byte[] newToCryptoKeyData = CryptreeNodeUtil.encrypt(plainCryptoKey.getEncodedKey(), (CipherParameters)request.getNewKey().getPublicKey().getPublicKey());
            cryptoLink.setToCryptoKeyData(newToCryptoKeyData);
            cryptoLink.setFromUserRepoKeyPublicKey(request.getNewKey());
            cryptoLink.setLastSyncFromRepositoryId(null);
            this.getCryptreeContext().getSignableSigner(oldKeySigningUserRepoKey).sign((Signable)cryptoLink);
        }
        cryptoLinks = cryptoLinkDao.getCryptoLinksSignedBy(request.getOldKey().getUserRepoKeyId());
        for (CryptoLink cryptoLink : cryptoLinks) {
            cryptoLink.setLastSyncFromRepositoryId(null);
            this.getCryptreeContext().getSignableSigner(oldKeySigningUserRepoKey).sign((Signable)cryptoLink);
        }
        Collection<Permission> permissions = permissionDao.getPermissions(request.getOldKey());
        for (Permission permission : permissions) {
            permission.setUserRepoKeyPublicKey(request.getNewKey());
            this.getCryptreeContext().getSignableSigner(oldKeySigningUserRepoKey).sign((Signable)permission);
        }
        permissions = permissionDao.getPermissionsSignedBy(request.getOldKey().getUserRepoKeyId());
        for (Permission permission : permissions) {
            this.getCryptreeContext().getSignableSigner(oldKeySigningUserRepoKey).sign((Signable)permission);
        }
        User user = this.getCryptreeContext().getUserRegistry().getUserByUserRepoKeyId(request.getOldKey().getUserRepoKeyId());
        if (user == null) {
            logger.warn("processUserRepoKeyPublicKeyReplacementRequestAsInvitingUser: userRepoKeyId = {} unknown! Maybe already processed?!", (Object)request.getOldKey().getUserRepoKeyId());
        } else {
            UserIdentityPayloadDto userIdentityPayloadDto = this.getUserIdentityPayloadDtoOrFail(request.getNewKey().getUserRepoKeyId());
            UserRepoKeyPublicKeyDtoWithSignatureConverter urkpkConverter = new UserRepoKeyPublicKeyDtoWithSignatureConverter();
            UserRepoKey.PublicKeyWithSignature newPublicKey = urkpkConverter.fromUserRepoKeyPublicKeyDto(userIdentityPayloadDto.getUserRepoKeyPublicKeyDto());
            Objects.requireNonNull(newPublicKey, "newPublicKey");
            ArrayList<UserRepoKey.PublicKeyWithSignature> oldPublicKeys = new ArrayList<UserRepoKey.PublicKeyWithSignature>();
            for (UserRepoKey.PublicKeyWithSignature pk : user.getUserRepoKeyPublicKeys()) {
                if (!pk.getUserRepoKeyId().equals((Object)request.getOldKey().getUserRepoKeyId())) continue;
                oldPublicKeys.add(pk);
            }
            user.getUserRepoKeyPublicKeys().removeAll(oldPublicKeys);
            user.getUserRepoKeyPublicKeys().add(newPublicKey);
        }
        UserRepoKeyPublicKeyReplacementRequestDeletion requestDeletion = new UserRepoKeyPublicKeyReplacementRequestDeletion(request);
        this.getCryptreeContext().getSignableSigner(oldKeySigningUserRepoKey).sign((Signable)requestDeletion);
        requestDeletion = (UserRepoKeyPublicKeyReplacementRequestDeletion)requestDeletionDao.makePersistent(requestDeletion);
        this.deleteUserRepoKeyPublicKeyReplacementRequestWithOldKey(request, null);
    }

    public void removeOrphanedInvitationUserRepoKeyPublicKeys() {
        long start = System.currentTimeMillis();
        LocalRepoTransaction tx = this.getTransactionOrFail();
        RemoteRepositoryDao rrDao = (RemoteRepositoryDao)tx.getDao(RemoteRepositoryDao.class);
        HashSet<UUID> serverRepositoryIds = new HashSet<UUID>(1);
        for (RemoteRepository serverRepository : rrDao.getObjects()) {
            serverRepositoryIds.add(serverRepository.getRepositoryId());
        }
        UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)tx.getDao(UserRepoKeyPublicKeyDao.class));
        for (User user : this.getCryptreeContext().getUserRegistry().getUsers()) {
            ArrayList<UserRepoKey.PublicKeyWithSignature> userRepoKeyPublicKeysToBeRemoved = new ArrayList<UserRepoKey.PublicKeyWithSignature>();
            for (UserRepoKey.PublicKeyWithSignature pk : user.getUserRepoKeyPublicKeys()) {
                UserRepoKeyPublicKey urkpk;
                if (!pk.isInvitation() || !serverRepositoryIds.contains(pk.getServerRepositoryId()) || (urkpk = urkpkDao.getUserRepoKeyPublicKey(pk.getUserRepoKeyId())) != null) continue;
                userRepoKeyPublicKeysToBeRemoved.add(pk);
            }
            if (userRepoKeyPublicKeysToBeRemoved.isEmpty()) continue;
            user.getUserRepoKeyPublicKeys().removeAll(userRepoKeyPublicKeysToBeRemoved);
            logger.warn("removeOrphanedInvitationUserRepoKeyPublicKeys: Removed {} public keys from user {}! removed={} kept={}", new Object[]{userRepoKeyPublicKeysToBeRemoved.size(), user, userRepoKeyPublicKeysToBeRemoved, user.getUserRepoKeyPublicKeys()});
        }
        this.getCryptreeContext().getUserRegistry().writeIfNeeded();
        logger.debug("removeOrphanedInvitationUserRepoKeyPublicKeys took {} ms.", (Object)(System.currentTimeMillis() - start));
    }

    private void putUserRepoKeyPublicKeyReplacementRequestDeletionDto(UserRepoKeyPublicKeyReplacementRequestDeletionDto requestDeletionDto) {
        Objects.requireNonNull(requestDeletionDto, "requestDeletionDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        UserRepoKeyPublicKeyReplacementRequestDao requestDao = (UserRepoKeyPublicKeyReplacementRequestDao)((Object)transaction.getDao(UserRepoKeyPublicKeyReplacementRequestDao.class));
        UserRepoKeyPublicKeyReplacementRequestDeletionDao requestDeletionDao = (UserRepoKeyPublicKeyReplacementRequestDeletionDao)((Object)transaction.getDao(UserRepoKeyPublicKeyReplacementRequestDeletionDao.class));
        UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserRepoKeyPublicKeyReplacementRequestDeletion requestDeletion = requestDeletionDao.getUserRepoKeyPublicKeyReplacementRequestDeletion(requestDeletionDto.getRequestId());
        if (requestDeletion == null) {
            requestDeletion = new UserRepoKeyPublicKeyReplacementRequestDeletion(requestDeletionDto.getRequestId(), requestDeletionDto.getOldUserRepoKeyId());
        }
        requestDeletion.setSignature(requestDeletionDto.getSignature());
        requestDeletion = (UserRepoKeyPublicKeyReplacementRequestDeletion)requestDeletionDao.makePersistent(requestDeletion);
        UserRepoKeyPublicKeyReplacementRequest request = requestDao.getUserRepoKeyPublicKeyReplacementRequest(requestDeletion.getRequestId());
        InvitationUserRepoKeyPublicKey oldKey = null;
        Uid oldUserRepoKeyId = requestDeletion.getOldUserRepoKeyId();
        if (oldUserRepoKeyId != null) {
            UserRepoKeyPublicKey key = urkpkDao.getUserRepoKeyPublicKey(oldUserRepoKeyId);
            oldKey = (InvitationUserRepoKeyPublicKey)key;
        }
        if (request != null || oldKey != null) {
            this.deleteUserRepoKeyPublicKeyReplacementRequestWithOldKey(request, oldKey);
        }
    }

    private void putUserIdentityDto(UserIdentityDto userIdentityDto) {
        Objects.requireNonNull(userIdentityDto, "userIdentityDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        UserIdentityDao uiDao = (UserIdentityDao)((Object)transaction.getDao(UserIdentityDao.class));
        UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserIdentity userIdentity = uiDao.getUserIdentity(userIdentityDto.getUserIdentityId());
        if (userIdentity == null) {
            userIdentity = new UserIdentity(userIdentityDto.getUserIdentityId());
        }
        userIdentity.setOfUserRepoKeyPublicKey(urkpkDao.getUserRepoKeyPublicKeyOrFail(userIdentityDto.getOfUserRepoKeyId()));
        userIdentity.setEncryptedUserIdentityPayloadDtoData(userIdentityDto.getEncryptedUserIdentityPayloadDto());
        userIdentity.setSignature(userIdentityDto.getSignature());
        userIdentity = (UserIdentity)uiDao.makePersistent(userIdentity);
        this.deleteOtherUserIdentitiesOfSameUserRepoKeyPublicKey(userIdentity);
    }

    private void deleteOtherUserIdentitiesOfSameUserRepoKeyPublicKey(UserIdentity userIdentity) {
        Objects.requireNonNull(userIdentity, "userIdentity");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        UserIdentityDao uiDao = (UserIdentityDao)((Object)transaction.getDao(UserIdentityDao.class));
        Collection<UserIdentity> userIdentities = uiDao.getUserIdentitiesOf(userIdentity.getOfUserRepoKeyPublicKey());
        for (UserIdentity ui : userIdentities) {
            if (ui.equals((Object)userIdentity)) continue;
            uiDao.deletePersistent(ui);
        }
    }

    private void putUserIdentityLinkDto(UserIdentityLinkDto userIdentityLinkDto) {
        Objects.requireNonNull(userIdentityLinkDto, "userIdentityLinkDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        UserIdentityDao uiDao = (UserIdentityDao)((Object)transaction.getDao(UserIdentityDao.class));
        UserIdentityLinkDao uilDao = (UserIdentityLinkDao)((Object)transaction.getDao(UserIdentityLinkDao.class));
        UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserIdentityLink userIdentityLink = uilDao.getUserIdentityLink(userIdentityLinkDto.getUserIdentityLinkId());
        if (userIdentityLink == null) {
            userIdentityLink = new UserIdentityLink(userIdentityLinkDto.getUserIdentityLinkId());
        }
        userIdentityLink.setUserIdentity(uiDao.getUserIdentityOrFail(userIdentityLinkDto.getUserIdentityId()));
        userIdentityLink.setForUserRepoKeyPublicKey(urkpkDao.getUserRepoKeyPublicKeyOrFail(userIdentityLinkDto.getForUserRepoKeyId()));
        userIdentityLink.setEncryptedUserIdentityKeyData(userIdentityLinkDto.getEncryptedUserIdentityKeyData());
        userIdentityLink.setSignature(userIdentityLinkDto.getSignature());
        userIdentityLink = (UserIdentityLink)uilDao.makePersistent(userIdentityLink);
    }

    private void deleteUserRepoKeyPublicKeyReplacementRequestWithOldKey(UserRepoKeyPublicKeyReplacementRequest request, InvitationUserRepoKeyPublicKey oldKey) {
        if (request == null && oldKey == null) {
            throw new IllegalArgumentException("Both request and oldKey are null!");
        }
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        transaction.flush();
        if (oldKey == null) {
            oldKey = request.getOldKey();
        }
        UserRepoKeyPublicKeyReplacementRequestDao urkpkrrDao = (UserRepoKeyPublicKeyReplacementRequestDao)((Object)transaction.getDao(UserRepoKeyPublicKeyReplacementRequestDao.class));
        if (request != null) {
            urkpkrrDao.deletePersistent(request);
        }
        transaction.flush();
        Collection<UserRepoKeyPublicKeyReplacementRequest> otherRequests = urkpkrrDao.getUserRepoKeyPublicKeyReplacementRequestsForOldKey(oldKey);
        if (otherRequests.isEmpty()) {
            Uid oldUserRepoKeyId = oldKey.getUserRepoKeyId();
            ((UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class))).deletePersistent(oldKey);
            transaction.flush();
            UserRepoKeyRing userRepoKeyRing = this.getCryptreeContext().userRepoKeyRing;
            if (userRepoKeyRing != null) {
                userRepoKeyRing.removeUserRepoKey(oldUserRepoKeyId);
            }
        } else {
            logger.warn("deleteUserRepoKeyPublicKeyReplacementRequestWithOldKey: Not deleting oldKey={}, because there are other requests referencing it! {}", (Object)oldKey, otherRequests);
        }
    }

    public UserIdentityPayloadDto getUserIdentityPayloadDtoOrFail(Uid userRepoKeyId) throws ReadUserIdentityAccessDeniedException {
        Objects.requireNonNull(userRepoKeyId, "userRepoKeyId");
        UserRepoKeyPublicKeyDao userRepoKeyPublicKeyDao = (UserRepoKeyPublicKeyDao)((Object)this.getCryptreeContext().transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserRepoKeyPublicKey ofUserRepoKeyPublicKey = userRepoKeyPublicKeyDao.getUserRepoKeyPublicKey(userRepoKeyId);
        if (ofUserRepoKeyPublicKey == null) {
            throw new IllegalArgumentException("There is no UserRepoKeyPublicKey with userRepoKeyId=" + userRepoKeyId);
        }
        UserRepoKeyPublicKeyHelper helper = new UserRepoKeyPublicKeyHelper(this.getCryptreeContext());
        UserIdentityPayloadDto userIdentityPayloadDto = helper.getUserIdentityPayloadDto(ofUserRepoKeyPublicKey);
        if (userIdentityPayloadDto != null) {
            return userIdentityPayloadDto;
        }
        throw new ReadUserIdentityAccessDeniedException();
    }

    public UserRepoKey getUserRepoKey(String localPath, PermissionType permissionType) {
        Objects.requireNonNull(permissionType, "permissionType");
        CryptreeNode cryptreeNode = localPath == null ? this.getCryptreeContext().getCryptreeNodeOrCreate(this.getRootCryptoRepoFileIdOrFail()) : this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        return cryptreeNode.getUserRepoKey(localPath == null, permissionType);
    }

    public UserRepoKey getUserRepoKeyOrFail(String localPath, PermissionType permissionType) throws AccessDeniedException {
        UserRepoKey userRepoKey = this.getUserRepoKey(localPath, permissionType);
        if (userRepoKey == null) {
            String message = String.format("No UserRepoKey available for '%s' at localPath='%s'!", permissionType, localPath);
            switch (permissionType) {
                case grant: {
                    throw new GrantAccessDeniedException(message);
                }
                case read: {
                    throw new ReadAccessDeniedException(message);
                }
                case write: {
                    throw new WriteAccessDeniedException(message);
                }
            }
            throw new IllegalArgumentException("Unknown PermissionType: " + permissionType);
        }
        return userRepoKey;
    }

    public Uid getRootCryptoRepoFileIdOrFail() {
        Uid rootCryptoRepoFileId = this.getRootCryptoRepoFileId();
        return Objects.requireNonNull(rootCryptoRepoFileId, "rootCryptoRepoFileId");
    }

    public Uid getRootCryptoRepoFileId() {
        if (this.rootCryptoRepoFileId == null) {
            CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)this.getTransactionOrFail().getDao(CryptoRepoFileDao.class));
            CryptoRepoFile rootCryptoRepoFile = cryptoRepoFileDao.getRootCryptoRepoFile();
            this.rootCryptoRepoFileId = rootCryptoRepoFile == null ? null : rootCryptoRepoFile.getCryptoRepoFileId();
        }
        return this.rootCryptoRepoFileId;
    }

    public RepoFileDto getDecryptedRepoFileDtoOrFail(Uid cryptoRepoFileId) throws AccessDeniedException {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
        RepoFileDto repoFileDto = cryptreeNode.getRepoFileDto();
        Objects.requireNonNull(repoFileDto, "cryptreeNode.getRepoFileDto()");
        return repoFileDto;
    }

    public RepoFileDto getDecryptedRepoFileDto(String localPath) throws AccessDeniedException {
        Objects.requireNonNull(localPath, "localPath");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        return cryptreeNode.getRepoFileDto();
    }

    public RepoFileDto getDecryptedRepoFileOnServerDtoOrFail(Uid cryptoRepoFileId) throws AccessDeniedException, FileDeletedException {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
        RepoFileDto repoFileDto = cryptreeNode.getRepoFileDtoOnServer();
        Objects.requireNonNull(repoFileDto, "cryptreeNode.getRepoFileDtoOnServer()");
        return repoFileDto;
    }

    public RepoFileDto getDecryptedRepoFileOnServerDto(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        try {
            return cryptreeNode.getRepoFileDtoOnServer();
        }
        catch (FileDeletedException x) {
            logger.warn("getDecryptedRepoFileOnServerDto: localPath='{}': " + (Object)((Object)x), (Object)localPath);
            return null;
        }
    }

    public void grantPermission(String localPath, PermissionType permissionType, UserRepoKey.PublicKey userRepoKeyPublicKey) {
        Objects.requireNonNull(localPath, "localPath");
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyPublicKey, "userRepoKeyPublicKey");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        cryptreeNode.grantPermission(permissionType, userRepoKeyPublicKey);
    }

    public void requestReplaceInvitationUserRepoKey(UserRepoKey invitationUserRepoKey, UserRepoKey.PublicKey publicKey) {
        Objects.requireNonNull(invitationUserRepoKey, "invitationUserRepoKey");
        Objects.requireNonNull(publicKey, "publicKey");
        logger.info("requestReplaceInvitationUserRepoKey: invitationUserRepoKey={}, publicKey={}", (Object)invitationUserRepoKey, (Object)publicKey);
        if (invitationUserRepoKey.getValidTo() == null) {
            throw new IllegalArgumentException("invitationUserRepoKey is not a temporary UserRepoKey :: invitationUserRepoKey.getValidTo() == null");
        }
        LocalRepoTransaction tx = this.getCryptreeContext().transaction;
        UserRepoKeyPublicKeyReplacementRequestDao userRepoKeyPublicKeyReplacementRequestDao = (UserRepoKeyPublicKeyReplacementRequestDao)((Object)tx.getDao(UserRepoKeyPublicKeyReplacementRequestDao.class));
        UserRepoKeyPublicKeyHelper userRepoKeyPublicKeyHelper = new UserRepoKeyPublicKeyHelper(this.getCryptreeContext());
        InvitationUserRepoKeyPublicKey invitationUserRepoKeyPublicKey = (InvitationUserRepoKeyPublicKey)userRepoKeyPublicKeyHelper.getUserRepoKeyPublicKeyOrCreate((UserRepoKey.PublicKey)invitationUserRepoKey.getPublicKey());
        UserRepoKeyPublicKey userRepoKeyPublicKey = userRepoKeyPublicKeyHelper.getUserRepoKeyPublicKeyOrCreate(publicKey);
        UserRepoKeyPublicKeyReplacementRequest request = new UserRepoKeyPublicKeyReplacementRequest();
        request.setOldKey(invitationUserRepoKeyPublicKey);
        request.setNewKey(userRepoKeyPublicKey);
        this.cryptreeContext.getSignableSigner(invitationUserRepoKey).sign((Signable)request);
        userRepoKeyPublicKeyReplacementRequestDao.makePersistent(request);
    }

    public void registerRemotePathPrefix(String pathPrefix) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)this.getTransactionOrFail().getDao(RemoteRepositoryDao.class);
        RemoteRepository remoteRepository = remoteRepositoryDao.getRemoteRepositoryOrFail(this.getServerRepositoryIdOrFail());
        SsRemoteRepository rr = (SsRemoteRepository)remoteRepository;
        rr.setRemotePathPrefix(pathPrefix);
    }

    public void revokePermission(String localPath, PermissionType permissionType, Set<Uid> userRepoKeyIds) {
        Objects.requireNonNull(localPath, "localPath");
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyIds, "userRepoKeyIds");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        cryptreeNode.revokePermission(permissionType, userRepoKeyIds);
    }

    public void grantPermission(Uid cryptoRepoFileId, PermissionType permissionType, UserRepoKey.PublicKey userRepoKeyPublicKey) {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyPublicKey, "userRepoKeyPublicKey");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
        cryptreeNode.grantPermission(permissionType, userRepoKeyPublicKey);
    }

    public void revokePermission(Uid cryptoRepoFileId, PermissionType permissionType, Set<Uid> userRepoKeyIds) {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyIds, "userRepoKeyIds");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
        cryptreeNode.revokePermission(permissionType, userRepoKeyIds);
    }

    public void setPermissionsInherited(String localPath, boolean inherited) {
        Objects.requireNonNull(localPath, "localPath");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        cryptreeNode.setPermissionsInherited(inherited);
    }

    public boolean isPermissionsInherited(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        return cryptreeNode.isPermissionsInherited();
    }

    public void setPermissionsInherited(Uid cryptoRepoFileId, boolean inherited) {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
        cryptreeNode.setPermissionsInherited(inherited);
    }

    public boolean isPermissionsInherited(Uid cryptoRepoFileId) {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
        return cryptreeNode.isPermissionsInherited();
    }

    protected boolean isOnServer() {
        return this.getUserRepoKeyRing() == null;
    }

    private CryptoRepoFile putCryptoRepoFileDto(CryptoRepoFileDto cryptoRepoFileDto) {
        Objects.requireNonNull(cryptoRepoFileDto, "cryptoRepoFileDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        CryptoKeyDao cryptoKeyDao = (CryptoKeyDao)((Object)transaction.getDao(CryptoKeyDao.class));
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)transaction.getDao(CryptoRepoFileDao.class));
        Uid cryptoRepoFileId = Objects.requireNonNull(cryptoRepoFileDto.getCryptoRepoFileId(), "cryptoRepoFileDto.cryptoRepoFileId");
        CryptoRepoFile cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFile(cryptoRepoFileId);
        if (cryptoRepoFile == null) {
            cryptoRepoFile = new CryptoRepoFile(cryptoRepoFileId);
        }
        Uid cryptoKeyId = Objects.requireNonNull(cryptoRepoFileDto.getCryptoKeyId(), "cryptoRepoFileDto.cryptoKeyId");
        cryptoRepoFile.setCryptoKey(cryptoKeyDao.getCryptoKey(cryptoKeyId));
        Uid parentCryptoRepoFileId = cryptoRepoFileDto.getParentCryptoRepoFileId();
        cryptoRepoFile.setParent(parentCryptoRepoFileId == null ? null : cryptoRepoFileDao.getCryptoRepoFileOrFail(parentCryptoRepoFileId));
        String remotePathPrefix = this.getRemotePathPrefix();
        if (remotePathPrefix == null || remotePathPrefix.isEmpty()) {
            if (parentCryptoRepoFileId == null) {
                LocalRepository localRepository = ((LocalRepositoryDao)transaction.getDao(LocalRepositoryDao.class)).getLocalRepositoryOrFail();
                cryptoRepoFile.setRepoFile((RepoFile)localRepository.getRoot());
            }
        } else {
            Uid id = this.getCryptreeContext().getCryptoRepoFileIdForRemotePathPrefixOrFail();
            if (id.equals((Object)cryptoRepoFile.getCryptoRepoFileId())) {
                LocalRepository localRepository = ((LocalRepositoryDao)transaction.getDao(LocalRepositoryDao.class)).getLocalRepositoryOrFail();
                cryptoRepoFile.setRepoFile((RepoFile)localRepository.getRoot());
            }
        }
        byte[] repoFileDtoData = Objects.requireNonNull(cryptoRepoFileDto.getRepoFileDtoData(), "cryptoRepoFileDto.repoFileDtoData");
        cryptoRepoFile.setRepoFileDtoData(repoFileDtoData);
        cryptoRepoFile.setDirectory(cryptoRepoFileDto.isDirectory());
        cryptoRepoFile.setLastSyncFromRepositoryId(this.getRemoteRepositoryIdOrFail());
        cryptoRepoFile.setCryptoRepoFileCreated(cryptoRepoFileDto.getCryptoRepoFileCreated());
        cryptoRepoFile.setDeleted(cryptoRepoFileDto.getDeleted());
        cryptoRepoFile.setDeletedByIgnoreRule(cryptoRepoFileDto.isDeletedByIgnoreRule());
        cryptoRepoFile.setSignature(cryptoRepoFileDto.getSignature());
        return (CryptoRepoFile)cryptoRepoFileDao.makePersistent(cryptoRepoFile);
    }

    protected void deleteRepoFileWithAllChildrenRecursively(RepoFile repoFile) {
        Objects.requireNonNull(repoFile, "repoFile");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
        for (RepoFile childRepoFile : repoFileDao.getChildRepoFiles(repoFile)) {
            this.deleteRepoFileWithAllChildrenRecursively(childRepoFile);
        }
        repoFileDao.deletePersistent(repoFile);
    }

    private UserRepoKeyPublicKey putUserRepoKeyPublicKeyDto(UserRepoKeyPublicKeyDto userRepoKeyPublicKeyDto) {
        Objects.requireNonNull(userRepoKeyPublicKeyDto, "userRepoKeyPublicKeyDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        UserRepoKeyPublicKeyDao userRepoKeyPublicKeyDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
        InvitationUserRepoKeyPublicKeyDto invUserRepoKeyPublicKeyDto = (InvitationUserRepoKeyPublicKeyDto)(userRepoKeyPublicKeyDto instanceof InvitationUserRepoKeyPublicKeyDto ? userRepoKeyPublicKeyDto : null);
        Uid userRepoKeyId = Objects.requireNonNull(userRepoKeyPublicKeyDto.getUserRepoKeyId(), "userRepoKeyPublicKeyDto.userRepoKeyId");
        UserRepoKeyPublicKey userRepoKeyPublicKey = userRepoKeyPublicKeyDao.getUserRepoKeyPublicKey(userRepoKeyId);
        if (userRepoKeyPublicKey == null) {
            userRepoKeyPublicKey = invUserRepoKeyPublicKeyDto != null ? new InvitationUserRepoKeyPublicKey(userRepoKeyId) : new UserRepoKeyPublicKey(userRepoKeyId);
        }
        userRepoKeyPublicKey.setServerRepositoryId(userRepoKeyPublicKeyDto.getRepositoryId());
        if (userRepoKeyPublicKey.getPublicKeyData() == null) {
            userRepoKeyPublicKey.setPublicKeyData(userRepoKeyPublicKeyDto.getPublicKeyData());
        } else if (!Arrays.equals(userRepoKeyPublicKey.getPublicKeyData(), userRepoKeyPublicKeyDto.getPublicKeyData())) {
            throw new IllegalStateException("Cannot re-assign UserRepoKeyPublicKey.publicKeyData! Attack?!");
        }
        if (invUserRepoKeyPublicKeyDto != null) {
            InvitationUserRepoKeyPublicKey invUserRepoKeyPublicKey = (InvitationUserRepoKeyPublicKey)userRepoKeyPublicKey;
            invUserRepoKeyPublicKey.setValidTo(invUserRepoKeyPublicKeyDto.getValidTo());
            invUserRepoKeyPublicKey.setSignature(invUserRepoKeyPublicKeyDto.getSignature());
        }
        return (UserRepoKeyPublicKey)userRepoKeyPublicKeyDao.makePersistent(userRepoKeyPublicKey);
    }

    private UserRepoKeyPublicKeyReplacementRequest putUserRepoKeyPublicKeyReplacementRequestDto(UserRepoKeyPublicKeyReplacementRequestDto requestDto) {
        Objects.requireNonNull(requestDto, "requestDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        UserRepoKeyPublicKeyDao keyDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserRepoKeyPublicKeyReplacementRequestDao requestDao = (UserRepoKeyPublicKeyReplacementRequestDao)((Object)transaction.getDao(UserRepoKeyPublicKeyReplacementRequestDao.class));
        UserRepoKeyPublicKeyReplacementRequest request = requestDao.getUserRepoKeyPublicKeyReplacementRequest(requestDto.getRequestId());
        if (request == null) {
            request = new UserRepoKeyPublicKeyReplacementRequest(requestDto.getRequestId());
        }
        InvitationUserRepoKeyPublicKey oldKey = (InvitationUserRepoKeyPublicKey)keyDao.getUserRepoKeyPublicKeyOrFail(requestDto.getOldKeyId());
        request.setOldKey(oldKey);
        UserRepoKeyPublicKey newKey = keyDao.getUserRepoKeyPublicKeyOrFail(requestDto.getNewKeyId());
        request.setNewKey(newKey);
        request.setSignature(requestDto.getSignature());
        request = (UserRepoKeyPublicKeyReplacementRequest)requestDao.makePersistent(request);
        this.getCryptreeContext().signableVerifier.verify((Signable)request);
        if (!oldKey.getUserRepoKeyId().equals((Object)request.getSignature().getSigningUserRepoKeyId())) {
            throw new SignatureException("UserRepoKeyPublicKeyReplacementRequest is not signed by its oldKey!");
        }
        return request;
    }

    private CryptoKey putCryptoKeyDto(CryptoKeyDto cryptoKeyDto) {
        CryptoKeyDeactivationDto cryptoKeyDeactivationDto;
        Objects.requireNonNull(cryptoKeyDto, "cryptoKeyDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        CryptoKeyDao cryptoKeyDao = (CryptoKeyDao)((Object)transaction.getDao(CryptoKeyDao.class));
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)transaction.getDao(CryptoRepoFileDao.class));
        Uid cryptoKeyId = Objects.requireNonNull(cryptoKeyDto.getCryptoKeyId(), "cryptoKeyDto.cryptoKeyId");
        CryptoKey cryptoKey = cryptoKeyDao.getCryptoKey(cryptoKeyId);
        if (cryptoKey == null) {
            cryptoKey = new CryptoKey(cryptoKeyId);
        }
        if ((cryptoKeyDeactivationDto = cryptoKeyDto.getCryptoKeyDeactivationDto()) != null) {
            CryptoKeyDeactivation cryptoKeyDeactivation = cryptoKey.getCryptoKeyDeactivation();
            if (cryptoKeyDeactivation == null) {
                cryptoKeyDeactivation = new CryptoKeyDeactivation();
            }
            Objects.requireNonNull(cryptoKeyDeactivationDto.getCryptoKeyId(), "cryptoKeyDeactivationDto.cryptoKeyId");
            if (!cryptoKeyDeactivationDto.getCryptoKeyId().equals((Object)cryptoKeyId)) {
                throw new IllegalStateException(String.format("cryptoKeyDeactivationDto.cryptoKeyId != cryptoKeyDto.cryptoKeyId :: %s != %s", cryptoKeyDeactivationDto.getCryptoKeyId(), cryptoKeyId));
            }
            cryptoKeyDeactivation.setCryptoKey(cryptoKey);
            cryptoKeyDeactivation.setSignature(cryptoKeyDeactivationDto.getSignature());
            cryptoKey.setCryptoKeyDeactivation(cryptoKeyDeactivation);
        }
        cryptoKey.setCryptoKeyRole(cryptoKeyDto.getCryptoKeyRole());
        cryptoKey.setCryptoKeyType(cryptoKeyDto.getCryptoKeyType());
        Uid cryptoRepoFileId = Objects.requireNonNull(cryptoKeyDto.getCryptoRepoFileId(), "cryptoKeyDto.cryptoRepoFileId");
        CryptoRepoFile cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFileOrFail(cryptoRepoFileId);
        cryptoKey.setCryptoRepoFile(cryptoRepoFile);
        cryptoKey.setLastSyncFromRepositoryId(this.getRemoteRepositoryIdOrFail());
        Objects.requireNonNull(cryptoKeyDto.getSignature(), "cryptoKeyDto.signature");
        Objects.requireNonNull(cryptoKeyDto.getSignature().getSignatureCreated(), "cryptoKeyDto.signature.signatureCreated");
        Objects.requireNonNull(cryptoKeyDto.getSignature().getSigningUserRepoKeyId(), "cryptoKeyDto.signature.signingUserRepoKeyId");
        Objects.requireNonNull(cryptoKeyDto.getSignature().getSignatureData(), "cryptoKeyDto.signature.signatureData");
        cryptoKey.setSignature(cryptoKeyDto.getSignature());
        return (CryptoKey)cryptoKeyDao.makePersistent(cryptoKey);
    }

    private CryptoLink putCryptoLinkDto(CryptoLinkDto cryptoLinkDto) {
        Uid fromCryptoKeyId;
        Objects.requireNonNull(cryptoLinkDto, "cryptoLinkDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        CryptoLinkDao cryptoLinkDao = (CryptoLinkDao)((Object)transaction.getDao(CryptoLinkDao.class));
        CryptoKeyDao cryptoKeyDao = (CryptoKeyDao)((Object)transaction.getDao(CryptoKeyDao.class));
        UserRepoKeyPublicKeyDao userRepoKeyPublicKeyDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
        Uid cryptoLinkId = Objects.requireNonNull(cryptoLinkDto.getCryptoLinkId(), "cryptoLinkDto.cryptoLinkId");
        CryptoLink cryptoLink = cryptoLinkDao.getCryptoLink(cryptoLinkId);
        if (cryptoLink == null) {
            cryptoLink = new CryptoLink(cryptoLinkId);
        }
        cryptoLink.setFromCryptoKey((fromCryptoKeyId = cryptoLinkDto.getFromCryptoKeyId()) == null ? null : cryptoKeyDao.getCryptoKeyOrFail(fromCryptoKeyId));
        Uid fromUserRepoKeyId = cryptoLinkDto.getFromUserRepoKeyId();
        cryptoLink.setFromUserRepoKeyPublicKey(fromUserRepoKeyId == null ? null : userRepoKeyPublicKeyDao.getUserRepoKeyPublicKeyOrFail(fromUserRepoKeyId));
        Uid toCryptoKeyId = Objects.requireNonNull(cryptoLinkDto.getToCryptoKeyId(), "cryptoLinkDto.toCryptoKeyId");
        CryptoKey toCryptoKey = cryptoKeyDao.getCryptoKeyOrFail(toCryptoKeyId);
        cryptoLink.setToCryptoKey(toCryptoKey);
        cryptoLink.setToCryptoKeyData(cryptoLinkDto.getToCryptoKeyData());
        cryptoLink.setToCryptoKeyPart(cryptoLinkDto.getToCryptoKeyPart());
        cryptoLink.setSignature(cryptoLinkDto.getSignature());
        cryptoLink.setLastSyncFromRepositoryId(this.getRemoteRepositoryIdOrFail());
        toCryptoKey.getInCryptoLinks().add(cryptoLink);
        return (CryptoLink)cryptoLinkDao.makePersistent(cryptoLink);
    }

    private void putCryptoConfigPropSetDtos(List<CryptoConfigPropSetDto> cryptoConfigPropSetDtos) {
        Objects.requireNonNull(cryptoConfigPropSetDtos, "cryptoConfigPropSetDtos");
        CryptoConfigPropSetDtoConverter converter = CryptoConfigPropSetDtoConverter.create(this.getTransactionOrFail());
        for (CryptoConfigPropSetDto cryptoConfigPropSetDto : cryptoConfigPropSetDtos) {
            CryptoConfigPropSet cryptoConfigPropSet = converter.putCryptoConfigPropSetDto(cryptoConfigPropSetDto);
            cryptoConfigPropSet.setLastSyncFromRepositoryId(this.getRemoteRepositoryIdOrFail());
        }
    }

    private void putPermissionDto(PermissionDto permissionDto) {
        SignableDao signableDao;
        Objects.requireNonNull(permissionDto, "permissionDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        PermissionDao permissionDao = (PermissionDao)((Object)transaction.getDao(PermissionDao.class));
        PermissionSetDao permissionSetDao = (PermissionSetDao)((Object)transaction.getDao(PermissionSetDao.class));
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)transaction.getDao(CryptoRepoFileDao.class));
        UserRepoKeyPublicKeyDao userRepoKeyPublicKeyDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
        Permission permission = permissionDao.getPermission(permissionDto.getPermissionId());
        if (permission == null) {
            permission = new Permission(permissionDto.getPermissionId());
        }
        CryptoRepoFile cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFileOrFail(permissionDto.getCryptoRepoFileId());
        PermissionSet permissionSet = permissionSetDao.getPermissionSetOrFail(cryptoRepoFile);
        permission.setPermissionSet(permissionSet);
        permission.setPermissionType(permissionDto.getPermissionType());
        permission.setRevoked(permissionDto.getRevoked());
        permission.setSignature(permissionDto.getSignature());
        UserRepoKeyPublicKey userRepoKeyPublicKey = userRepoKeyPublicKeyDao.getUserRepoKeyPublicKeyOrFail(permissionDto.getUserRepoKeyId());
        permission.setUserRepoKeyPublicKey(userRepoKeyPublicKey);
        permission.setValidFrom(permissionDto.getValidFrom());
        Date oldValidTo = permission.getValidTo();
        permission.setValidTo(permissionDto.getValidTo());
        permissionDao.makePersistent(permission);
        if (permission.getValidTo() != null && oldValidTo == null && this.isOnServer() && (signableDao = (SignableDao)((Object)this.getTransactionOrFail().getDao(SignableDao.class))).isEntitiesSignedByAndAfter(permission.getUserRepoKeyPublicKey().getUserRepoKeyId(), permission.getValidTo())) {
            throw new PermissionCollisionException("There is already data written and signed after the Permission.validTo timestamp. Are clocks in-sync?");
        }
    }

    private void putPermissionSetDto(PermissionSetDto permissionSetDto) {
        Objects.requireNonNull(permissionSetDto, "permissionSetDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        PermissionSetDao permissionSetDao = (PermissionSetDao)((Object)transaction.getDao(PermissionSetDao.class));
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)transaction.getDao(CryptoRepoFileDao.class));
        CryptoRepoFile cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFileOrFail(permissionSetDto.getCryptoRepoFileId());
        PermissionSet permissionSet = permissionSetDao.getPermissionSet(cryptoRepoFile);
        if (permissionSet == null) {
            permissionSet = new PermissionSet();
        }
        permissionSet.setCryptoRepoFile(cryptoRepoFile);
        permissionSet.setSignature(permissionSetDto.getSignature());
        permissionSetDao.makePersistent(permissionSet);
    }

    private void putPermissionSetInheritanceDto(PermissionSetInheritanceDto psInheritanceDto) {
        Objects.requireNonNull(psInheritanceDto, "psInheritanceDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        PermissionSetInheritanceDao psInheritanceDao = (PermissionSetInheritanceDao)((Object)transaction.getDao(PermissionSetInheritanceDao.class));
        PermissionSetDao permissionSetDao = (PermissionSetDao)((Object)transaction.getDao(PermissionSetDao.class));
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)transaction.getDao(CryptoRepoFileDao.class));
        PermissionSetInheritance psInheritance = psInheritanceDao.getPermissionSetInheritance(psInheritanceDto.getPermissionSetInheritanceId());
        if (psInheritance == null) {
            psInheritance = new PermissionSetInheritance(psInheritanceDto.getPermissionSetInheritanceId());
        }
        CryptoRepoFile cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFileOrFail(psInheritanceDto.getCryptoRepoFileId());
        PermissionSet permissionSet = permissionSetDao.getPermissionSetOrFail(cryptoRepoFile);
        psInheritance.setPermissionSet(permissionSet);
        psInheritance.setRevoked(psInheritanceDto.getRevoked());
        psInheritance.setSignature(psInheritanceDto.getSignature());
        psInheritance.setValidFrom(psInheritanceDto.getValidFrom());
        Date oldValidTo = psInheritance.getValidTo();
        psInheritance.setValidTo(psInheritanceDto.getValidTo());
        psInheritanceDao.makePersistent(psInheritance);
        if (psInheritance.getValidTo() != null && oldValidTo == null && this.isOnServer()) {
            HashSet<UserRepoKeyPublicKey> userRepoKeyPublicKeys = new HashSet<UserRepoKeyPublicKey>();
            this.collectUserRepoKeyPublicKeysOfThisAndParentPermissionSets(userRepoKeyPublicKeys, permissionSet);
            for (UserRepoKeyPublicKey userRepoKeyPublicKey : userRepoKeyPublicKeys) {
                SignableDao signableDao = (SignableDao)((Object)this.getTransactionOrFail().getDao(SignableDao.class));
                if (!signableDao.isEntitiesSignedByAndAfter(userRepoKeyPublicKey.getUserRepoKeyId(), psInheritance.getValidTo())) continue;
                throw new PermissionCollisionException("There is already data written and signed after the Permission.validTo timestamp. Are clocks in-sync?");
            }
        }
    }

    private void collectUserRepoKeyPublicKeysOfThisAndParentPermissionSets(Set<UserRepoKeyPublicKey> userRepoKeyPublicKeys, PermissionSet permissionSet) {
        Objects.requireNonNull(userRepoKeyPublicKeys, "userRepoKeyPublicKeys");
        Objects.requireNonNull(permissionSet, "permissionSet");
        for (Permission permission : permissionSet.getPermissions()) {
            userRepoKeyPublicKeys.add(permission.getUserRepoKeyPublicKey());
        }
        PermissionSet parentPermissionSet = this.getParentPermissionSet(permissionSet);
        if (parentPermissionSet != null) {
            this.collectUserRepoKeyPublicKeysOfThisAndParentPermissionSets(userRepoKeyPublicKeys, parentPermissionSet);
        }
    }

    private PermissionSet getParentPermissionSet(PermissionSet permissionSet) {
        PermissionSetDao permissionSetDao = (PermissionSetDao)((Object)this.getTransactionOrFail().getDao(PermissionSetDao.class));
        CryptoRepoFile parentCryptoRepoFile = permissionSet.getCryptoRepoFile();
        while (null != (parentCryptoRepoFile = parentCryptoRepoFile.getParent())) {
            PermissionSet parentPermissionSet = permissionSetDao.getPermissionSet(parentCryptoRepoFile);
            if (parentPermissionSet == null) continue;
            return parentPermissionSet;
        }
        return null;
    }

    private void putRepositoryOwnerDto(RepositoryOwnerDto repositoryOwnerDto) {
        Objects.requireNonNull(repositoryOwnerDto, "repositoryOwnerDto");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        RepositoryOwnerDao repositoryOwnerDao = (RepositoryOwnerDao)((Object)transaction.getDao(RepositoryOwnerDao.class));
        UserRepoKeyPublicKeyDao userRepoKeyPublicKeyDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserRepoKeyPublicKey userRepoKeyPublicKey = userRepoKeyPublicKeyDao.getUserRepoKeyPublicKeyOrFail(repositoryOwnerDto.getUserRepoKeyId());
        if (!repositoryOwnerDto.getServerRepositoryId().equals(userRepoKeyPublicKey.getServerRepositoryId())) {
            throw new IllegalStateException(String.format("repositoryOwnerDto.serverRepositoryId != userRepoKeyPublicKey.serverRepositoryId :: %s != %s :: userRepoKeyId=%s", repositoryOwnerDto.getServerRepositoryId(), userRepoKeyPublicKey.getServerRepositoryId(), userRepoKeyPublicKey.getUserRepoKeyId()));
        }
        RepositoryOwner repositoryOwner = repositoryOwnerDao.getRepositoryOwner(repositoryOwnerDto.getServerRepositoryId());
        if (repositoryOwner == null) {
            repositoryOwner = new RepositoryOwner();
        }
        if (repositoryOwner.getUserRepoKeyPublicKey() == null) {
            repositoryOwner.setUserRepoKeyPublicKey(userRepoKeyPublicKey);
        } else if (!userRepoKeyPublicKey.equals((Object)repositoryOwner.getUserRepoKeyPublicKey())) {
            throw new IllegalStateException(String.format("Cannot re-assign RepositoryOwner.userRepoKeyPublicKey! Attack?! assignedUserRepoKeyId=%s newUserRepoKeyId=%s", repositoryOwner.getUserRepoKeyPublicKey().getUserRepoKeyId(), userRepoKeyPublicKey.getUserRepoKeyId()));
        }
        repositoryOwner.setSignature(repositoryOwnerDto.getSignature());
        repositoryOwnerDao.makePersistent(repositoryOwner);
    }

    protected LastCryptoKeySyncToRemoteRepo getLastCryptoKeySyncToRemoteRepo() {
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        RemoteRepository remoteRepository = ((RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(this.getRemoteRepositoryIdOrFail());
        LastCryptoKeySyncToRemoteRepoDao lastCryptoKeySyncToRemoteRepoDao = (LastCryptoKeySyncToRemoteRepoDao)((Object)transaction.getDao(LastCryptoKeySyncToRemoteRepoDao.class));
        LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo = lastCryptoKeySyncToRemoteRepoDao.getLastCryptoKeySyncToRemoteRepo(remoteRepository);
        if (lastCryptoKeySyncToRemoteRepo == null) {
            lastCryptoKeySyncToRemoteRepo = new LastCryptoKeySyncToRemoteRepo();
            lastCryptoKeySyncToRemoteRepo.setRemoteRepository(remoteRepository);
            lastCryptoKeySyncToRemoteRepo = (LastCryptoKeySyncToRemoteRepo)lastCryptoKeySyncToRemoteRepoDao.makePersistent(lastCryptoKeySyncToRemoteRepo);
        }
        return lastCryptoKeySyncToRemoteRepo;
    }

    protected CryptoChangeSetDto getCryptoChangeSetDto(CryptoRepoFile cryptoRepoFile) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        LocalRepository localRepository = ((LocalRepositoryDao)this.getTransactionOrFail().getDao(LocalRepositoryDao.class)).getLocalRepositoryOrFail();
        LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo = this.getLastCryptoKeySyncToRemoteRepo();
        lastCryptoKeySyncToRemoteRepo.setLocalRepositoryRevisionInProgress(localRepository.getRevision());
        CryptoChangeSetDto cryptoChangeSetDto = new CryptoChangeSetDto();
        cryptoChangeSetDto.getCryptoRepoFileDtos().add(CryptoRepoFileDtoConverter.create().toCryptoRepoFileDto(cryptoRepoFile));
        this.populateCryptoChangeSetDtoWithAllButCryptoRepoFiles(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        logger.debug("getCryptoChangeSetDto({}): {}", (Object)cryptoRepoFile, (Object)cryptoChangeSetDto);
        return cryptoChangeSetDto;
    }

    private void populateCryptoChangeSetDtoWithAllButCryptoRepoFiles(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        logger.info("populateCryptoChangeSetDtoWithAllButCryptoRepoFiles: localRepositoryId={} remoteRepositoryId={}, lastCryptoKeySyncToRemoteRepo.localRepositoryRevisionSynced={}, lastCryptoKeySyncToRemoteRepo.localRepositoryRevisionInProgress={}", new Object[]{this.getLocalRepositoryIdOrFail(), lastCryptoKeySyncToRemoteRepo.getRemoteRepository().getRepositoryId(), lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced(), lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionInProgress()});
        this.populateRevision(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedUserRepoKeyPublicKeyDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedCryptoLinkDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedCryptoKeyDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedRepositoryOwnerDto(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedPermissionSetInheritanceDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedPermissionDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedPermissionSetDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedUserRepoKeyPublicKeyReplacementRequestDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedUserRepoKeyPublicKeyReplacementRequestDeletionDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedUserIdentityLinkDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedUserIdentityDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedCurrentHistoCryptoRepoFileDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedHistoCryptoRepoFileDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedHistoFrameDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedCollisionDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedDeletedCollisionDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
        this.populateChangedCryptoConfigPropSetDtos(cryptoChangeSetDto, lastCryptoKeySyncToRemoteRepo);
    }

    private void populateRevision(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        cryptoChangeSetDto.setRevision(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionInProgress());
        if (cryptoChangeSetDto.getRevision() < 0L) {
            throw new IllegalStateException("cryptoChangeSetDto.revision < 0");
        }
        logger.debug("populateRevision: Took {} ms.", (Object)(System.currentTimeMillis() - beginTimestamp));
    }

    private void populateChangedCryptoConfigPropSetDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        CryptoConfigPropSetDtoConverter converter = CryptoConfigPropSetDtoConverter.create(this.getTransactionOrFail());
        CryptoConfigPropSetDao dao = (CryptoConfigPropSetDao)((Object)this.getTransactionOrFail().getDao(CryptoConfigPropSetDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "CryptoConfigPropSetDto"});
        Collection<CryptoConfigPropSet> entities = dao.getCryptoConfigPropSetsChangedAfterExclLastSyncFromRepositoryId(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced(), lastCryptoKeySyncToRemoteRepo.isResyncMode() ? NULL_UUID : this.getRemoteRepositoryIdOrFail());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (CryptoConfigPropSet entity : entities) {
            cryptoChangeSetDto.getCryptoConfigPropSetDtos().add(converter.toCryptoConfigPropSetDto(entity));
        }
        logger.debug("populateChangedCryptoConfigPropSetDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void populateChangedCollisionDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        CollisionDtoConverter converter = CollisionDtoConverter.create(this.getTransactionOrFail());
        CollisionDao dao = (CollisionDao)((Object)this.getTransactionOrFail().getDao(CollisionDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "CollisionDto"});
        Collection<Collision> entities = dao.getCollisionsChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (Collision entity : entities) {
            cryptoChangeSetDto.getCollisionDtos().add(converter.toCollisionDto(entity));
        }
        logger.debug("populateChangedCollisionDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void populateChangedDeletedCollisionDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        DeletedCollisionDtoConverter converter = DeletedCollisionDtoConverter.create(this.getTransactionOrFail());
        DeletedCollisionDao dao = (DeletedCollisionDao)((Object)this.getTransactionOrFail().getDao(DeletedCollisionDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "DeletedCollisionDto"});
        Collection<DeletedCollision> entities = dao.getDeletedCollisionsChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (DeletedCollision entity : entities) {
            cryptoChangeSetDto.getDeletedCollisionDtos().add(converter.toDeletedCollisionDto(entity));
        }
        logger.debug("populateChangedDeletedCollisionDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void populateChangedHistoFrameDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        HistoFrameDtoConverter converter = HistoFrameDtoConverter.create(this.getTransactionOrFail());
        HistoFrameDao dao = (HistoFrameDao)((Object)this.getTransactionOrFail().getDao(HistoFrameDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "HistoFrameDto"});
        Collection<HistoFrame> entities = dao.getHistoFramesChangedAfterExclLastSyncFromRepositoryId(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced(), lastCryptoKeySyncToRemoteRepo.isResyncMode() ? NULL_UUID : this.getRemoteRepositoryIdOrFail());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (HistoFrame entity : entities) {
            cryptoChangeSetDto.getHistoFrameDtos().add(converter.toHistoFrameDto(entity));
        }
        logger.debug("populateChangedHistoFrameDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void populateChangedHistoCryptoRepoFileDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        if (!this.isOnServer() && !lastCryptoKeySyncToRemoteRepo.isResyncMode()) {
            return;
        }
        long beginTimestamp = System.currentTimeMillis();
        HistoCryptoRepoFileDtoConverter converter = HistoCryptoRepoFileDtoConverter.create(this.getTransactionOrFail());
        HistoCryptoRepoFileDao dao = (HistoCryptoRepoFileDao)((Object)this.getTransactionOrFail().getDao(HistoCryptoRepoFileDao.class));
        cryptoChangeSetDto.setHistoCryptoRepoFileDtos(dao.getHistoCryptoRepoFileDtosChangedAfterExclLastSyncFromRepositoryId(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced(), lastCryptoKeySyncToRemoteRepo.isResyncMode() ? NULL_UUID : this.getRemoteRepositoryIdOrFail()));
        logger.debug("populateChangedHistoCryptoRepoFileDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)cryptoChangeSetDto.getHistoCryptoRepoFileDtos().size());
    }

    private void populateChangedCurrentHistoCryptoRepoFileDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        if (!this.isOnServer() && !lastCryptoKeySyncToRemoteRepo.isResyncMode()) {
            return;
        }
        long beginTimestamp = System.currentTimeMillis();
        CurrentHistoCryptoRepoFileDtoConverter converter = CurrentHistoCryptoRepoFileDtoConverter.create(this.getTransactionOrFail());
        CurrentHistoCryptoRepoFileDao dao = (CurrentHistoCryptoRepoFileDao)((Object)this.getTransactionOrFail().getDao(CurrentHistoCryptoRepoFileDao.class));
        cryptoChangeSetDto.setCurrentHistoCryptoRepoFileDtos(dao.getCurrentHistoCryptoRepoFileDtosChangedAfterExclLastSyncFromRepositoryId(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced(), lastCryptoKeySyncToRemoteRepo.isResyncMode() ? NULL_UUID : this.getRemoteRepositoryIdOrFail()));
        logger.debug("populateChangedCurrentHistoCryptoRepoFileDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)cryptoChangeSetDto.getCurrentHistoCryptoRepoFileDtos().size());
    }

    private void populateChangedUserRepoKeyPublicKeyDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        UserRepoKeyPublicKeyDtoConverter userRepoKeyPublicKeyDtoConverter = new UserRepoKeyPublicKeyDtoConverter();
        UserRepoKeyPublicKeyDao userRepoKeyPublicKeyDao = (UserRepoKeyPublicKeyDao)((Object)this.getTransactionOrFail().getDao(UserRepoKeyPublicKeyDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "UserRepoKeyPublicKeyDto"});
        Collection<UserRepoKeyPublicKey> entities = userRepoKeyPublicKeyDao.getUserRepoKeyPublicKeysChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (UserRepoKeyPublicKey userRepoKeyPublicKey : entities) {
            cryptoChangeSetDto.getUserRepoKeyPublicKeyDtos().add(userRepoKeyPublicKeyDtoConverter.toUserRepoKeyPublicKeyDto(userRepoKeyPublicKey));
        }
        logger.debug("populateChangedUserRepoKeyPublicKeyDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void populateChangedCryptoRepoFileDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)this.getTransactionOrFail().getDao(CryptoRepoFileDao.class));
        cryptoChangeSetDto.setCryptoRepoFileDtos(cryptoRepoFileDao.getCryptoRepoFileDtosChangedAfterExclLastSyncFromRepositoryId(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced(), lastCryptoKeySyncToRemoteRepo.isResyncMode() ? NULL_UUID : this.getRemoteRepositoryIdOrFail()));
        logger.debug("populateChangedCryptoRepoFileDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)cryptoChangeSetDto.getCryptoRepoFileDtos().size());
    }

    private void populateChangedCryptoLinkDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        CryptoLinkDao cryptoLinkDao = (CryptoLinkDao)((Object)this.getTransactionOrFail().getDao(CryptoLinkDao.class));
        cryptoChangeSetDto.setCryptoLinkDtos(cryptoLinkDao.getCryptoLinkDtosChangedAfterExclLastSyncFromRepositoryId(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced(), lastCryptoKeySyncToRemoteRepo.isResyncMode() ? NULL_UUID : this.getRemoteRepositoryIdOrFail()));
        logger.debug("populateChangedCryptoLinkDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)cryptoChangeSetDto.getCryptoLinkDtos().size());
    }

    private void populateChangedCryptoKeyDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        CryptoKeyDao cryptoKeyDao = (CryptoKeyDao)((Object)this.getTransactionOrFail().getDao(CryptoKeyDao.class));
        cryptoChangeSetDto.setCryptoKeyDtos(cryptoKeyDao.getCryptoKeyDtosChangedAfterExclLastSyncFromRepositoryId(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced(), lastCryptoKeySyncToRemoteRepo.isResyncMode() ? NULL_UUID : this.getRemoteRepositoryIdOrFail()));
        logger.debug("populateChangedCryptoKeyDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)cryptoChangeSetDto.getCryptoKeyDtos().size());
    }

    private void populateChangedRepositoryOwnerDto(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        RepositoryOwnerDao repositoryOwnerDao = (RepositoryOwnerDao)((Object)this.getTransactionOrFail().getDao(RepositoryOwnerDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "RepositoryOwnerDto"});
        RepositoryOwner repositoryOwner = repositoryOwnerDao.getRepositoryOwner(this.getServerRepositoryIdOrFail());
        if (repositoryOwner != null && repositoryOwner.getLocalRevision() > lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced()) {
            cryptoChangeSetDto.setRepositoryOwnerDto(this.toRepositoryOwnerDto(repositoryOwner));
        }
        logger.debug("populateChangedRepositoryOwnerDto: Took {} ms.", (Object)(System.currentTimeMillis() - beginTimestamp));
    }

    private void populateChangedPermissionDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        PermissionDao permissionDao = (PermissionDao)((Object)this.getTransactionOrFail().getDao(PermissionDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "PermissionDto"});
        Collection<Permission> entities = permissionDao.getPermissionsChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (Permission permission : entities) {
            cryptoChangeSetDto.getPermissionDtos().add(this.toPermissionDto(permission));
        }
        logger.debug("populateChangedPermissionDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void enactPermissionRevocationsOfChangedPermissionsIfNeededAndPossible(LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        PermissionDao permissionDao = (PermissionDao)((Object)this.getTransactionOrFail().getDao(PermissionDao.class));
        Collection<Permission> entities = permissionDao.getPermissionsChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        for (Permission permission : entities) {
            this.enactPermissionRevocationIfNeededAndPossible(permission);
        }
    }

    private void enactPermissionSetInheritanceRevocationsOfChangedPermissionSetInheritancesIfNeededAndPossible(LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        PermissionSetInheritanceDao psInheritanceDao = (PermissionSetInheritanceDao)((Object)this.getTransactionOrFail().getDao(PermissionSetInheritanceDao.class));
        Collection<PermissionSetInheritance> entities = psInheritanceDao.getPermissionSetInheritancesChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        for (PermissionSetInheritance psInheritance : entities) {
            this.enactPermissionSetInheritanceRevocationIfNeededAndPossible(psInheritance);
        }
    }

    private void populateChangedPermissionSetInheritanceDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        PermissionSetInheritanceDao psInheritanceDao = (PermissionSetInheritanceDao)((Object)this.getTransactionOrFail().getDao(PermissionSetInheritanceDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "PermissionSetInheritanceDto"});
        Collection<PermissionSetInheritance> entities = psInheritanceDao.getPermissionSetInheritancesChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (PermissionSetInheritance psInheritance : entities) {
            cryptoChangeSetDto.getPermissionSetInheritanceDtos().add(this.toPermissionSetInheritanceDto(psInheritance));
        }
        logger.debug("populateChangedPermissionSetInheritanceDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void enactPermissionRevocationIfNeededAndPossible(Permission permission) {
        if (!this.isOnServer() && permission.getRevoked() != null && permission.getValidTo() == null) {
            permission.setValidTo(new Date());
            try {
                this.sign(permission);
            }
            catch (GrantAccessDeniedException x) {
                permission.setValidTo(null);
                logger.warn("Cannot enact revocation of Permission because of missing permission: " + (Object)((Object)x), (Throwable)x);
            }
        }
    }

    private void enactPermissionSetInheritanceRevocationIfNeededAndPossible(PermissionSetInheritance psInheritance) {
        if (!this.isOnServer() && psInheritance.getRevoked() != null && psInheritance.getValidTo() == null) {
            psInheritance.setValidTo(new Date());
            try {
                this.sign(psInheritance);
            }
            catch (GrantAccessDeniedException x) {
                psInheritance.setValidTo(null);
                logger.warn("Cannot enact revocation of PermissionSetInheritance because of missing permission: " + (Object)((Object)x), (Throwable)x);
            }
        }
    }

    public void sign(WriteProtected writeProtected) throws AccessDeniedException {
        CryptreeNode rootCryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(this.getRootCryptoRepoFileId());
        rootCryptreeNode.sign(writeProtected);
    }

    private void populateChangedPermissionSetDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        PermissionSetDao permissionSetDao = (PermissionSetDao)((Object)this.getTransactionOrFail().getDao(PermissionSetDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "PermissionSetDto"});
        Collection<PermissionSet> entities = permissionSetDao.getPermissionSetsChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (PermissionSet permissionSet : entities) {
            cryptoChangeSetDto.getPermissionSetDtos().add(this.toPermissionSetDto(permissionSet));
        }
        logger.debug("populateChangedPermissionSetDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void populateChangedUserRepoKeyPublicKeyReplacementRequestDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        UserRepoKeyPublicKeyReplacementRequestDtoConverter converter = new UserRepoKeyPublicKeyReplacementRequestDtoConverter();
        UserRepoKeyPublicKeyReplacementRequestDao dao = (UserRepoKeyPublicKeyReplacementRequestDao)((Object)this.getTransactionOrFail().getDao(UserRepoKeyPublicKeyReplacementRequestDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "CryptoChangeSetDto"});
        Collection<UserRepoKeyPublicKeyReplacementRequest> entities = dao.getUserRepoKeyPublicKeyReplacementRequestsChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (UserRepoKeyPublicKeyReplacementRequest request : entities) {
            cryptoChangeSetDto.getUserRepoKeyPublicKeyReplacementRequestDtos().add(converter.toUserRepoKeyPublicKeyReplacementRequestDto(request));
        }
        logger.debug("populateChangedUserRepoKeyPublicKeyReplacementRequestDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void populateChangedUserRepoKeyPublicKeyReplacementRequestDeletionDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        UserRepoKeyPublicKeyReplacementRequestDeletionDtoConverter converter = new UserRepoKeyPublicKeyReplacementRequestDeletionDtoConverter();
        UserRepoKeyPublicKeyReplacementRequestDeletionDao dao = (UserRepoKeyPublicKeyReplacementRequestDeletionDao)((Object)this.getTransactionOrFail().getDao(UserRepoKeyPublicKeyReplacementRequestDeletionDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "CryptoChangeSetDto"});
        Collection<UserRepoKeyPublicKeyReplacementRequestDeletion> entities = dao.getUserRepoKeyPublicKeyReplacementRequestDeletionsChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (UserRepoKeyPublicKeyReplacementRequestDeletion requestDeletion : entities) {
            cryptoChangeSetDto.getUserRepoKeyPublicKeyReplacementRequestDeletionDtos().add(converter.toUserRepoKeyPublicKeyReplacementRequestDeletionDto(requestDeletion));
        }
        logger.debug("populateChangedUserRepoKeyPublicKeyReplacementRequestDeletionDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void populateChangedUserIdentityDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        UserIdentityDtoConverter converter = new UserIdentityDtoConverter();
        UserIdentityDao dao = (UserIdentityDao)((Object)this.getTransactionOrFail().getDao(UserIdentityDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "CryptoChangeSetDto"});
        Collection<UserIdentity> entities = dao.getUserIdentitiesChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (UserIdentity userIdentity : entities) {
            cryptoChangeSetDto.getUserIdentityDtos().add(converter.toUserIdentityDto(userIdentity));
        }
        logger.debug("populateChangedUserIdentityDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private void populateChangedUserIdentityLinkDtos(CryptoChangeSetDto cryptoChangeSetDto, LastCryptoKeySyncToRemoteRepo lastCryptoKeySyncToRemoteRepo) {
        long beginTimestamp = System.currentTimeMillis();
        UserIdentityLinkDtoConverter converter = new UserIdentityLinkDtoConverter();
        UserIdentityLinkDao dao = (UserIdentityLinkDao)((Object)this.getTransactionOrFail().getDao(UserIdentityLinkDao.class));
        this.pm().getFetchPlan().setGroups(new String[]{"default", "CryptoChangeSetDto"});
        Collection<UserIdentityLink> entities = dao.getUserIdentityLinksChangedAfter(lastCryptoKeySyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        this.pm().getFetchPlan().setGroups(new String[]{"default", "Signature"});
        for (UserIdentityLink userIdentityLink : entities) {
            cryptoChangeSetDto.getUserIdentityLinkDtos().add(converter.toUserIdentityLinkDto(userIdentityLink));
        }
        logger.debug("populateChangedUserIdentityLinkDtos: Took {} ms for {} entities.", (Object)(System.currentTimeMillis() - beginTimestamp), (Object)entities.size());
    }

    private CryptoLinkDto toCryptoLinkDto(CryptoLink cryptoLink) {
        Objects.requireNonNull(cryptoLink, "cryptoLink");
        CryptoLinkDto cryptoLinkDto = new CryptoLinkDto();
        cryptoLinkDto.setCryptoLinkId(cryptoLink.getCryptoLinkId());
        CryptoKey fromCryptoKey = cryptoLink.getFromCryptoKey();
        cryptoLinkDto.setFromCryptoKeyId(fromCryptoKey == null ? null : fromCryptoKey.getCryptoKeyId());
        UserRepoKeyPublicKey fromUserRepoKeyPublicKey = cryptoLink.getFromUserRepoKeyPublicKey();
        cryptoLinkDto.setFromUserRepoKeyId(fromUserRepoKeyPublicKey == null ? null : fromUserRepoKeyPublicKey.getUserRepoKeyId());
        cryptoLinkDto.setToCryptoKeyData(cryptoLink.getToCryptoKeyData());
        cryptoLinkDto.setToCryptoKeyId(cryptoLink.getToCryptoKey().getCryptoKeyId());
        cryptoLinkDto.setToCryptoKeyPart(cryptoLink.getToCryptoKeyPart());
        cryptoLinkDto.setSignature(Objects.requireNonNull(cryptoLink.getSignature(), "cryptoLink.signature"));
        return cryptoLinkDto;
    }

    private CryptoKeyDto toCryptoKeyDto(CryptoKey cryptoKey) {
        Objects.requireNonNull(cryptoKey, "cryptoKey");
        CryptoKeyDto cryptoKeyDto = new CryptoKeyDto();
        cryptoKeyDto.setCryptoKeyId(cryptoKey.getCryptoKeyId());
        cryptoKeyDto.setCryptoRepoFileId(cryptoKey.getCryptoRepoFile().getCryptoRepoFileId());
        CryptoKeyDeactivation cryptoKeyDeactivation = cryptoKey.getCryptoKeyDeactivation();
        if (cryptoKeyDeactivation != null) {
            cryptoKeyDto.setCryptoKeyDeactivationDto(this.toCryptoKeyDeactivationDto(cryptoKeyDeactivation, cryptoKey));
        }
        cryptoKeyDto.setCryptoKeyRole(Objects.requireNonNull(cryptoKey.getCryptoKeyRole(), "cryptoKey.cryptoKeyRole"));
        cryptoKeyDto.setCryptoKeyType(Objects.requireNonNull(cryptoKey.getCryptoKeyType(), "cryptoKey.cryptoKeyType"));
        cryptoKeyDto.setSignature(Objects.requireNonNull(cryptoKey.getSignature(), "cryptoKey.signature"));
        return cryptoKeyDto;
    }

    private CryptoKeyDeactivationDto toCryptoKeyDeactivationDto(CryptoKeyDeactivation cryptoKeyDeactivation, CryptoKey cryptoKey) {
        Objects.requireNonNull(cryptoKeyDeactivation, "cryptoKeyDeactivation");
        Objects.requireNonNull(cryptoKey, "cryptoKey");
        CryptoKeyDeactivationDto cryptoKeyDeactivationDto = new CryptoKeyDeactivationDto();
        cryptoKeyDeactivationDto.setCryptoKeyId(Objects.requireNonNull(cryptoKey.getCryptoKeyId(), "cryptoKeyDeactivation.cryptoKey.cryptoKeyId"));
        cryptoKeyDeactivationDto.setSignature(cryptoKeyDeactivation.getSignature());
        return cryptoKeyDeactivationDto;
    }

    private RepositoryOwnerDto toRepositoryOwnerDto(RepositoryOwner repositoryOwner) {
        Objects.requireNonNull(repositoryOwner, "repositoryOwner");
        RepositoryOwnerDto repositoryOwnerDto = new RepositoryOwnerDto();
        repositoryOwnerDto.setServerRepositoryId(repositoryOwner.getServerRepositoryId());
        repositoryOwnerDto.setSignature(repositoryOwner.getSignature());
        repositoryOwnerDto.setUserRepoKeyId(repositoryOwner.getUserRepoKeyPublicKey().getUserRepoKeyId());
        return repositoryOwnerDto;
    }

    private PermissionSetDto toPermissionSetDto(PermissionSet permissionSet) {
        Objects.requireNonNull(permissionSet, "permissionSet");
        PermissionSetDto permissionSetDto = new PermissionSetDto();
        permissionSetDto.setCryptoRepoFileId(permissionSet.getCryptoRepoFile().getCryptoRepoFileId());
        permissionSetDto.setSignature(permissionSet.getSignature());
        return permissionSetDto;
    }

    private PermissionDto toPermissionDto(Permission permission) {
        Objects.requireNonNull(permission, "permission");
        PermissionDto permissionDto = new PermissionDto();
        permissionDto.setCryptoRepoFileId(permission.getPermissionSet().getCryptoRepoFile().getCryptoRepoFileId());
        permissionDto.setPermissionId(permission.getPermissionId());
        permissionDto.setPermissionType(permission.getPermissionType());
        permissionDto.setRevoked(permission.getRevoked());
        permissionDto.setSignature(permission.getSignature());
        permissionDto.setUserRepoKeyId(permission.getUserRepoKeyPublicKey().getUserRepoKeyId());
        permissionDto.setValidFrom(permission.getValidFrom());
        permissionDto.setValidTo(permission.getValidTo());
        return permissionDto;
    }

    private PermissionSetInheritanceDto toPermissionSetInheritanceDto(PermissionSetInheritance psInheritance) {
        Objects.requireNonNull(psInheritance, "psInheritance");
        PermissionSetInheritanceDto psInheritanceDto = new PermissionSetInheritanceDto();
        psInheritanceDto.setPermissionSetInheritanceId(psInheritance.getPermissionSetInheritanceId());
        psInheritanceDto.setCryptoRepoFileId(psInheritance.getPermissionSet().getCryptoRepoFile().getCryptoRepoFileId());
        psInheritanceDto.setRevoked(psInheritance.getRevoked());
        psInheritanceDto.setSignature(psInheritance.getSignature());
        psInheritanceDto.setValidFrom(psInheritance.getValidFrom());
        psInheritanceDto.setValidTo(psInheritance.getValidTo());
        return psInheritanceDto;
    }

    public boolean isEmpty() {
        Collection<CryptoRepoFile> childCryptoRepoFiles = ((CryptoRepoFileDao)((Object)this.getTransactionOrFail().getDao(CryptoRepoFileDao.class))).getChildCryptoRepoFiles(null);
        return childCryptoRepoFiles.isEmpty();
    }

    public void initLocalRepositoryType() {
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        LocalRepository lr = ((LocalRepositoryDao)transaction.getDao(LocalRepositoryDao.class)).getLocalRepositoryOrFail();
        SsLocalRepository localRepository = (SsLocalRepository)lr;
        LocalRepositoryType localRepositoryType = localRepository.getLocalRepositoryType();
        switch (localRepositoryType) {
            case UNINITIALISED: {
                localRepository.setLocalRepositoryType(this.isOnServer() ? LocalRepositoryType.SERVER : LocalRepositoryType.CLIENT);
                break;
            }
            case CLIENT: 
            case CLIENT_META_ONLY: {
                if (!this.isOnServer()) break;
                throw new IllegalStateException("SsLocalRepository.localRepositoryType is already initialised to " + (Object)((Object)localRepositoryType) + "! Cannot switch to SERVER!");
            }
            case SERVER: {
                if (this.isOnServer()) break;
                throw new IllegalStateException("SsLocalRepository.localRepositoryType is already initialised to SERVER! Cannot switch to CLIENT!");
            }
            default: {
                throw new IllegalStateException("Unknown localRepositoryType: " + (Object)((Object)localRepositoryType));
            }
        }
    }

    private void claimRepositoryOwnershipIfUnowned() {
        if (this.isOnServer()) {
            return;
        }
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        RepositoryOwnerDao roDao = (RepositoryOwnerDao)((Object)transaction.getDao(RepositoryOwnerDao.class));
        UUID serverRepositoryId = this.getServerRepositoryIdOrFail();
        UserRepoKeyRing userRepoKeyRing = this.getUserRepoKeyRingOrFail();
        RepositoryOwner repositoryOwner = roDao.getRepositoryOwner(serverRepositoryId);
        if (repositoryOwner == null) {
            UserRepoKey userRepoKey;
            UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
            UserRepoKeyPublicKey userRepoKeyPublicKey = urkpkDao.getUserRepoKeyPublicKey((userRepoKey = (UserRepoKey)userRepoKeyRing.getPermanentUserRepoKeys(serverRepositoryId).get(0)).getUserRepoKeyId());
            if (userRepoKeyPublicKey == null) {
                userRepoKeyPublicKey = (UserRepoKeyPublicKey)urkpkDao.makePersistent(new UserRepoKeyPublicKey((UserRepoKey.PublicKey)userRepoKey.getPublicKey()));
            }
            repositoryOwner = new RepositoryOwner();
            repositoryOwner.setUserRepoKeyPublicKey(userRepoKeyPublicKey);
            this.getCryptreeContext().getSignableSigner(userRepoKey).sign((Signable)repositoryOwner);
            repositoryOwner = roDao.makePersistent(repositoryOwner);
        }
    }

    public void assertSignatureOk(WriteProtected writeProtected) throws SignatureException, AccessDeniedException {
        Uid crfIdControllingPermissions = writeProtected.getCryptoRepoFileIdControllingPermissions();
        if (crfIdControllingPermissions == null) {
            CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)this.getTransactionOrFail().getDao(CryptoRepoFileDao.class));
            crfIdControllingPermissions = cryptoRepoFileDao.getRootCryptoRepoFile().getCryptoRepoFileId();
        }
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(crfIdControllingPermissions);
        cryptreeNode.assertSignatureOk(writeProtected);
    }

    public Set<PermissionType> getGrantedPermissionTypes(String localPath, Uid userRepoKeyId) {
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        return cryptreeNode.getGrantedPermissionTypes(userRepoKeyId);
    }

    public void assertIsNotDeletedDuplicateCryptoRepoFile(Uid cryptoRepoFileId) {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        Collection<Collision> collisions = ((CollisionDao)((Object)this.getCryptreeContext().transaction.getDao(CollisionDao.class))).getCollisionsWithDuplicateCryptoRepoFileId(cryptoRepoFileId);
        if (!collisions.isEmpty()) {
            throw new CollisionException("CryptoRepoFile was deleted due to being a duplicate! cryptoRepoFileId = " + cryptoRepoFileId);
        }
    }

    public void assertHasPermission(Uid cryptoRepoFileId, Uid userRepoKeyId, PermissionType permissionType, Date timestamp) throws AccessDeniedException {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        Objects.requireNonNull(userRepoKeyId, "userRepoKeyId");
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(timestamp, "timestamp");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
        cryptreeNode.assertHasPermission(false, userRepoKeyId, permissionType, timestamp);
    }

    public void assertHasPermission(String localPath, Uid userRepoKeyId, PermissionType permissionType, Date timestamp) throws AccessDeniedException {
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        cryptreeNode.assertHasPermission(false, userRepoKeyId, permissionType, timestamp);
    }

    public Uid getCryptoRepoFileIdForRemotePathPrefixOrFail() {
        return this.getCryptreeContext().getCryptoRepoFileIdForRemotePathPrefixOrFail();
    }

    public Uid getCryptoRepoFileIdOrFail(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        CryptoRepoFile cryptoRepoFile = cryptreeNode.getCryptoRepoFile();
        return cryptoRepoFile == null ? null : cryptoRepoFile.getCryptoRepoFileId();
    }

    public Uid getCryptoRepoFileId(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        CryptoRepoFile cryptoRepoFile = this.getCryptreeContext().getCryptoRepoFile(localPath);
        return cryptoRepoFile == null ? null : cryptoRepoFile.getCryptoRepoFileId();
    }

    public Uid getParentCryptoRepoFileId(Uid cryptoRepoFileId) {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        if (this.getRootCryptoRepoFileId().equals((Object)cryptoRepoFileId)) {
            return null;
        }
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
        CryptoRepoFile parent = Objects.requireNonNull(cryptreeNode.getCryptoRepoFile(), "cryptreeNode.cryptoRepoFile").getParent();
        Objects.requireNonNull(parent, "cryptreeNode.cryptoRepoFile.parent");
        return parent.getCryptoRepoFileId();
    }

    public Uid getOwnerUserRepoKeyId() {
        RepositoryOwner repositoryOwner = this.getCryptreeContext().getRepositoryOwner();
        if (repositoryOwner == null) {
            return null;
        }
        return repositoryOwner.getUserRepoKeyPublicKey().getUserRepoKeyId();
    }

    public LocalRepoStorage getLocalRepoStorage() {
        if (this.localRepoStorage == null) {
            LocalRepoStorageFactoryRegistry registry = LocalRepoStorageFactoryRegistry.getInstance();
            LocalRepoStorageFactory factory = registry.getLocalRepoStorageFactoryOrFail();
            if (this.getRemotePathPrefix() == null) {
                return factory.getLocalRepoStorageOrCreate(this.getTransactionOrFail());
            }
            return factory.getLocalRepoStorageOrCreate(this.getTransactionOrFail(), this.getRemoteRepositoryIdOrFail(), this.getRemotePathPrefixOrFail());
        }
        return this.localRepoStorage;
    }

    public CryptoChangeSetDto createHistoCryptoRepoFilesForDeletedCryptoRepoFiles() {
        this.convertPreliminaryDeletions();
        this.repairDeleteCollisionsIfNeeded();
        LocalRepoTransaction tx = this.getTransactionOrFail();
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)tx.getDao(CryptoRepoFileDao.class));
        Collection<CryptoRepoFile> deletedCryptoRepoFiles = cryptoRepoFileDao.getDeletedCryptoRepoFilesWithoutCurrentHistoCryptoRepoFileAlsoDeleted();
        ArrayList<HistoCryptoRepoFile> histoCryptoRepoFiles = new ArrayList<HistoCryptoRepoFile>();
        if (deletedCryptoRepoFiles.isEmpty()) {
            return null;
        }
        this.createUnsealedHistoFrameIfNeeded();
        for (CryptoRepoFile deletedCryptoRepoFile : deletedCryptoRepoFiles) {
            CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(deletedCryptoRepoFile.getCryptoRepoFileId());
            histoCryptoRepoFiles.add(cryptreeNode.createHistoCryptoRepoFileIfNeeded());
        }
        this.prepareGetCryptoChangeSetDtoWithCryptoRepoFiles(null);
        CryptoChangeSetDto cryptoChangeSetDto = this.getCryptoChangeSetDtoWithCryptoRepoFiles(null);
        CurrentHistoCryptoRepoFileDao chcrfDao = (CurrentHistoCryptoRepoFileDao)((Object)tx.getDao(CurrentHistoCryptoRepoFileDao.class));
        HistoCryptoRepoFileDtoConverter hcrfdConverter = HistoCryptoRepoFileDtoConverter.create(tx);
        CurrentHistoCryptoRepoFileDtoConverter chcrfdConverter = CurrentHistoCryptoRepoFileDtoConverter.create(tx);
        for (HistoCryptoRepoFile histoCryptoRepoFile : histoCryptoRepoFiles) {
            CryptoRepoFile cryptoRepoFile = histoCryptoRepoFile.getCryptoRepoFile();
            CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = chcrfDao.getCurrentHistoCryptoRepoFile(cryptoRepoFile);
            cryptoChangeSetDto.getHistoCryptoRepoFileDtos().add(hcrfdConverter.toHistoCryptoRepoFileDto(histoCryptoRepoFile));
            cryptoChangeSetDto.getCurrentHistoCryptoRepoFileDtos().add(chcrfdConverter.toCurrentHistoCryptoRepoFileDto(currentHistoCryptoRepoFile, false));
        }
        return cryptoChangeSetDto;
    }

    protected void repairDeleteCollisionsIfNeeded() {
        if (this.isOnServer()) {
            return;
        }
        LocalRepoTransaction tx = this.getTransactionOrFail();
        File localRoot = tx.getLocalRepoManager().getLocalRoot();
        Date[] deleteCollisionsFromInclToExclRange = RepairDeleteCollisionConfig.getInstance((File)localRoot).getDeleteCollisionsFromInclToExclRange();
        if (deleteCollisionsFromInclToExclRange == null) {
            return;
        }
        CollisionDao cDao = (CollisionDao)((Object)tx.getDao(CollisionDao.class));
        DeletedCollisionDao dcDao = (DeletedCollisionDao)((Object)tx.getDao(DeletedCollisionDao.class));
        Collection<Collision> collisions = cDao.getCollisionsSignedBetween(deleteCollisionsFromInclToExclRange[0], deleteCollisionsFromInclToExclRange[1]);
        if (collisions.isEmpty()) {
            return;
        }
        logger.info("repairDeleteCollisionsIfNeeded: Deleting {} collisions.", (Object)collisions.size());
        UserRepoKey userRepoKey = this.getUserRepoKeyOrFail(null, PermissionType.write);
        for (Collision collision : collisions) {
            logger.info("repairDeleteCollisionsIfNeeded: Deleting: {}", (Object)collision);
            Uid collisionId = collision.getCollisionId();
            DeletedCollision deletedCollision = dcDao.getDeletedCollision(collisionId);
            if (deletedCollision == null) {
                deletedCollision = new DeletedCollision(collisionId);
            }
            this.getCryptreeContext().getSignableSigner(userRepoKey).sign((Signable)deletedCollision);
            deletedCollision = (DeletedCollision)dcDao.makePersistent(deletedCollision);
            cDao.deletePersistent(collision);
            tx.flush();
        }
    }

    public void createUnsealedHistoFrameIfNeeded() {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        HistoFrameDao histoFrameDao = (HistoFrameDao)((Object)tx.getDao(HistoFrameDao.class));
        UUID fromRepositoryId = this.getLocalRepositoryIdOrFail();
        if (this.getRootCryptoRepoFileId() == null) {
            this.createOrUpdateCryptoRepoFile("");
        }
        UserRepoKey userRepoKey = this.getUserRepoKeyOrFail(null, PermissionType.write);
        HistoFrame histoFrame = histoFrameDao.getUnsealedHistoFrame(fromRepositoryId);
        if (histoFrame == null) {
            histoFrame = new HistoFrame();
            histoFrame.setFromRepositoryId(fromRepositoryId);
            histoFrame.setLastSyncFromRepositoryId(null);
            this.getCryptreeContext().getSignableSigner(userRepoKey).sign((Signable)histoFrame);
            histoFrame = (HistoFrame)histoFrameDao.makePersistent(histoFrame);
        }
    }

    private void convertPreliminaryCollisions() {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        File localRoot = tx.getLocalRepoManager().getLocalRoot();
        PreliminaryCollisionDao pcDao = (PreliminaryCollisionDao)((Object)tx.getDao(PreliminaryCollisionDao.class));
        RepoFileDao rfDao = (RepoFileDao)tx.getDao(RepoFileDao.class);
        CryptoRepoFileDao crfDao = (CryptoRepoFileDao)((Object)tx.getDao(CryptoRepoFileDao.class));
        Collection preliminaryCollisions = pcDao.getObjects();
        if (RepairDeleteCollisionConfig.getInstance((File)localRoot).isCreateCollisionSuppressed()) {
            logger.warn("convertPreliminaryCollisions: SKIPPED (createCollisionSuppressed=true): Deleting preliminaryCollisions={}", (Object)preliminaryCollisions);
            pcDao.deletePersistentAll(preliminaryCollisions);
            return;
        }
        for (PreliminaryCollision preliminaryCollision : preliminaryCollisions) {
            CryptoRepoFile cryptoRepoFile;
            File file = OioFileFactory.createFile((File)tx.getLocalRepoManager().getLocalRoot(), (String[])new String[]{preliminaryCollision.getPath()});
            RepoFile repoFile = rfDao.getRepoFile(tx.getLocalRepoManager().getLocalRoot(), file);
            CryptoRepoFile cryptoRepoFile2 = cryptoRepoFile = repoFile == null ? null : crfDao.getCryptoRepoFileOrFail(repoFile);
            if (cryptoRepoFile == null) {
                cryptoRepoFile = preliminaryCollision.getCryptoRepoFile();
            }
            if (cryptoRepoFile == null) {
                throw new IllegalStateException(String.format("Could not determine CryptoRepoFile for: %s (path='%s')", new Object[]{preliminaryCollision, preliminaryCollision.getPath()}));
            }
            CryptoRepoFile cryptoRepoFile22 = preliminaryCollision.getCryptoRepoFile();
            if (!cryptoRepoFile.equals((Object)cryptoRepoFile22)) {
                throw new IllegalStateException("preliminaryCollision.cryptoRepoFile points to different CryptoRepoFile than repoFile!");
            }
            this.createCollisionIfNeeded(cryptoRepoFile, null, preliminaryCollision.getPath(), false);
            pcDao.deletePersistent(preliminaryCollision);
        }
    }

    public Collision createCollisionIfNeeded(CryptoRepoFile cryptoRepoFile, CryptoRepoFile duplicateCryptoRepoFile, String localPath, boolean expectedSealedStatus) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        return this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFile.getCryptoRepoFileId()).createCollisionIfNeeded(duplicateCryptoRepoFile, localPath, expectedSealedStatus);
    }

    public void sealUnsealedHistoryFrame() {
        this.convertPreliminaryCollisions();
        LocalRepoTransaction tx = this.getTransactionOrFail();
        HistoFrameDao histoFrameDao = (HistoFrameDao)((Object)tx.getDao(HistoFrameDao.class));
        CryptreeNode rootCryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(this.getRootCryptoRepoFileId());
        UserRepoKey userRepoKey = rootCryptreeNode.getUserRepoKey(true, PermissionType.write);
        HistoFrame histoFrame = histoFrameDao.getUnsealedHistoFrame(this.getLocalRepositoryIdOrFail());
        if (histoFrame != null) {
            histoFrame.setSealed(new Date());
            histoFrame.setLastSyncFromRepositoryId(null);
            this.getCryptreeContext().getSignableSigner(userRepoKey).sign((Signable)histoFrame);
        }
    }

    public void putHistoFrameDto(HistoFrameDto histoFrameDto) {
        Objects.requireNonNull(histoFrameDto, "histoFrameDto");
        LocalRepoTransaction tx = this.getTransactionOrFail();
        HistoFrame histoFrame = HistoFrameDtoConverter.create(tx).putHistoFrameDto(histoFrameDto);
        histoFrame.setLastSyncFromRepositoryId(this.getRemoteRepositoryIdOrFail());
    }

    private Collision putCollisionDto(CollisionDto collisionDto) {
        Objects.requireNonNull(collisionDto, "collisionDto");
        LocalRepoTransaction tx = this.getTransactionOrFail();
        Collision collision = CollisionDtoConverter.create(tx).putCollisionDto(collisionDto);
        DuplicateCryptoRepoFileHandler.createInstance(tx).deduplicateFromCollisionIfNeeded(collision);
        return collision;
    }

    public void preDelete(String localPath, boolean deletedByIgnoreRule) {
        PreliminaryDeletionDao pdDao;
        PreliminaryDeletion preliminaryDeletion;
        Objects.requireNonNull(localPath, "localPath");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        CryptoRepoFile cryptoRepoFile = cryptreeNode.getCryptoRepoFile();
        if (cryptoRepoFile != null && (preliminaryDeletion = (pdDao = (PreliminaryDeletionDao)((Object)this.getTransactionOrFail().getDao(PreliminaryDeletionDao.class))).getPreliminaryDeletion(cryptoRepoFile)) == null) {
            preliminaryDeletion = new PreliminaryDeletion();
            preliminaryDeletion.setCryptoRepoFile(cryptoRepoFile);
            preliminaryDeletion.setDeletedByIgnoreRule(deletedByIgnoreRule);
            pdDao.makePersistent(preliminaryDeletion);
        }
    }

    private void convertPreliminaryDeletions() {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        PreliminaryDeletionDao pdDao = (PreliminaryDeletionDao)((Object)tx.getDao(PreliminaryDeletionDao.class));
        CryptreeContext cryptreeContext = this.getCryptreeContext();
        for (PreliminaryDeletion preliminaryDeletion : pdDao.getObjects()) {
            CryptoRepoFile cryptoRepoFile = preliminaryDeletion.getCryptoRepoFile();
            CryptreeNode cryptreeNode = cryptreeContext.getCryptreeNodeOrCreate(cryptoRepoFile.getCryptoRepoFileId());
            if (cryptoRepoFile != null && cryptoRepoFile.getDeleted() == null) {
                cryptoRepoFile.setDeleted(new Date());
                cryptoRepoFile.setDeletedByIgnoreRule(preliminaryDeletion.isDeletedByIgnoreRule());
                cryptoRepoFile.setLastSyncFromRepositoryId(null);
                cryptreeNode.sign(cryptoRepoFile);
                cryptreeNode.updateCryptoConfigPropSetIfConfigFile();
            }
            pdDao.deletePersistent(preliminaryDeletion);
        }
        tx.flush();
    }

    public void createSyntheticDeleteModifications(ChangeSetDto changeSetDto) {
        Objects.requireNonNull(changeSetDto, "changeSetDto");
        LocalRepoTransaction tx = this.getTransactionOrFail();
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)tx.getDao(CryptoRepoFileDao.class));
        Collection<CryptoRepoFile> cryptoRepoFiles = cryptoRepoFileDao.getCryptoRepoFilesWithRepoFileAndDeleted();
        for (CryptoRepoFile cryptoRepoFile : cryptoRepoFiles) {
            if (cryptoRepoFile.isDeletedByIgnoreRule()) continue;
            String path = cryptoRepoFile.getRepoFile().getPath();
            DeleteModificationDto deleteModificationDto = new DeleteModificationDto();
            deleteModificationDto.setId(nextModificationId.getAndIncrement());
            deleteModificationDto.setPath(path);
            changeSetDto.getModificationDtos().add(deleteModificationDto);
        }
    }

    public Collection<PlainHistoCryptoRepoFileDto> getPlainHistoCryptoRepoFileDtos(PlainHistoCryptoRepoFileFilter filter) {
        Objects.requireNonNull(filter, "filter");
        if ("/".equals(filter.getLocalPath())) {
            filter = filter.clone();
            filter.setLocalPath("");
        }
        LocalRepoTransaction tx = this.getTransactionOrFail();
        HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)((Object)tx.getDao(HistoCryptoRepoFileDao.class));
        Uid histoFrameId = filter.getHistoFrameId();
        if (histoFrameId != null) {
            if (filter.getHistoCryptoRepoFileIds() != null) {
                throw new UnsupportedOperationException("Filtering by both histoFrameId and histoCryptoRepoFileIds is currently not supported!");
            }
            if (filter.getCollisionIds() != null) {
                throw new UnsupportedOperationException("Filtering by both histoFrameId and collisionIds is currently not supported!");
            }
            HistoFrame histoFrame = ((HistoFrameDao)((Object)tx.getDao(HistoFrameDao.class))).getHistoFrameOrFail(histoFrameId);
            Collection<HistoCryptoRepoFile> histoCryptoRepoFiles = hcrfDao.getHistoCryptoRepoFiles(histoFrame);
            return this.getPlainHistoCryptoRepoFileDtos(histoCryptoRepoFiles, filter);
        }
        Set histoCryptoRepoFileIds = filter.getHistoCryptoRepoFileIds();
        if (histoCryptoRepoFileIds != null) {
            if (filter.getCollisionIds() != null) {
                throw new UnsupportedOperationException("Filtering by both histoCryptoRepoFileIds and collisionIds is currently not supported!");
            }
            ArrayList<HistoCryptoRepoFile> histoCryptoRepoFiles = new ArrayList<HistoCryptoRepoFile>(histoCryptoRepoFileIds.size());
            for (Uid histoCryptoRepoFileId : histoCryptoRepoFileIds) {
                HistoCryptoRepoFile histoCryptoRepoFile = hcrfDao.getHistoCryptoRepoFile(histoCryptoRepoFileId);
                if (histoCryptoRepoFile == null) continue;
                histoCryptoRepoFiles.add(histoCryptoRepoFile);
            }
            return this.getPlainHistoCryptoRepoFileDtos(histoCryptoRepoFiles, filter);
        }
        Set collisionIds = filter.getCollisionIds();
        if (collisionIds != null) {
            Collection<HistoCryptoRepoFile> histoCryptoRepoFiles = hcrfDao.getHistoCryptoRepoFilesByCollisions(collisionIds);
            return this.getPlainHistoCryptoRepoFileDtos(histoCryptoRepoFiles, filter);
        }
        throw new IllegalArgumentException("No constraints! Cannot query *all* PlainHistoCryptoRepoFiles!");
    }

    private Collection<PlainHistoCryptoRepoFileDto> getPlainHistoCryptoRepoFileDtos(Collection<HistoCryptoRepoFile> histoCryptoRepoFiles, PlainHistoCryptoRepoFileFilter filter) {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)((Object)tx.getDao(HistoCryptoRepoFileDao.class));
        HashMap<Uid, PlainHistoCryptoRepoFileDto> cryptoRepoFileId2PlainHistoCryptoRepoFileDto = new HashMap<Uid, PlainHistoCryptoRepoFileDto>();
        CryptreeNode filterLocalPathCryptreeNode = StringUtil.isEmpty((String)filter.getLocalPath()) ? null : this.getCryptreeContext().getCryptreeNodeOrCreate(filter.getLocalPath());
        CryptoRepoFile filterLocalPathCryptoRepoFile = filterLocalPathCryptreeNode == null ? null : Objects.requireNonNull(filterLocalPathCryptreeNode.getCryptoRepoFile(), "filterLocalPathCryptreeNode.cryptoRepoFile");
        ArrayList<PlainHistoCryptoRepoFileDto> result = new ArrayList<PlainHistoCryptoRepoFileDto>(histoCryptoRepoFiles.size());
        PlainHistoCryptoRepoFileDao plainHistoCryptoRepoFileDao = (PlainHistoCryptoRepoFileDao)((Object)tx.getDao(PlainHistoCryptoRepoFileDao.class));
        for (HistoCryptoRepoFile histoCryptoRepoFile : histoCryptoRepoFiles) {
            if (filterLocalPathCryptoRepoFile != null && !this.isParentOrEqual(filterLocalPathCryptoRepoFile, histoCryptoRepoFile.getCryptoRepoFile())) continue;
            PlainHistoCryptoRepoFile plainHistoCryptoRepoFile = plainHistoCryptoRepoFileDao.getPlainHistoCryptoRepoFileOrFail(histoCryptoRepoFile);
            PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto = plainHistoCryptoRepoFile.getPlainHistoCryptoRepoFileDto();
            if (plainHistoCryptoRepoFileDto.getAction() == null) {
                UpdatePlainHistoCryptoRepoFilesMarker.getInstance(tx).getHistoCryptoRepoFileIds().add(histoCryptoRepoFile.getHistoCryptoRepoFileId());
            }
            if (!filter.isWithFileChunkDtos()) {
                this.removeFileChunkDtos(plainHistoCryptoRepoFileDto);
            }
            cryptoRepoFileId2PlainHistoCryptoRepoFileDto.put(plainHistoCryptoRepoFileDto.getCryptoRepoFileId(), plainHistoCryptoRepoFileDto);
            result.add(plainHistoCryptoRepoFileDto);
        }
        if (filter.isFillParents()) {
            ArrayList<PlainHistoCryptoRepoFileDto> parentDtos = new ArrayList<PlainHistoCryptoRepoFileDto>();
            for (PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto : result) {
                if (plainHistoCryptoRepoFileDto.getRepoFileDto() == null) continue;
                Uid cryptoRepoFileId = plainHistoCryptoRepoFileDto.getHistoCryptoRepoFileDto().getCryptoRepoFileId();
                CryptoRepoFile cryptoRepoFile = this.getCryptreeContext().getCryptoRepoFileOrFail(cryptoRepoFileId);
                block2: for (CryptoRepoFile parentCryptoRepoFile : cryptoRepoFile.getPathList()) {
                    Uid parentCryptoRepoFileId = parentCryptoRepoFile.getCryptoRepoFileId();
                    if (cryptoRepoFileId2PlainHistoCryptoRepoFileDto.containsKey(parentCryptoRepoFileId)) continue;
                    for (HistoCryptoRepoFile parentHistoCryptoRepoFile : hcrfDao.getHistoCryptoRepoFiles(parentCryptoRepoFile)) {
                        PlainHistoCryptoRepoFile parentPlainHistoCryptoRepoFile = plainHistoCryptoRepoFileDao.getPlainHistoCryptoRepoFileOrFail(parentHistoCryptoRepoFile);
                        PlainHistoCryptoRepoFileDto parentPlainHistoCryptoRepoFileDto = parentPlainHistoCryptoRepoFile.getPlainHistoCryptoRepoFileDto();
                        if (parentPlainHistoCryptoRepoFileDto.getRepoFileDto() == null) continue;
                        cryptoRepoFileId2PlainHistoCryptoRepoFileDto.put(parentCryptoRepoFileId, parentPlainHistoCryptoRepoFileDto);
                        parentPlainHistoCryptoRepoFileDto.setHistoCryptoRepoFileDto(null);
                        parentPlainHistoCryptoRepoFileDto.setAction(null);
                        parentDtos.add(parentPlainHistoCryptoRepoFileDto);
                        continue block2;
                    }
                }
            }
            result.addAll(parentDtos);
        }
        return result;
    }

    public void updatePlainHistoCryptoRepoFiles(Set<Uid> histoCryptoRepoFileIds) {
        Objects.requireNonNull(histoCryptoRepoFileIds, "histoCryptoRepoFileIds");
        LocalRepoTransaction tx = this.getTransactionOrFail();
        HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)((Object)tx.getDao(HistoCryptoRepoFileDao.class));
        for (Uid histoCryptoRepoFileId : histoCryptoRepoFileIds) {
            HistoCryptoRepoFile histoCryptoRepoFile = hcrfDao.getHistoCryptoRepoFileOrFail(histoCryptoRepoFileId);
            this.getCryptreeContext().getCryptreeNodeOrCreate(histoCryptoRepoFile.getCryptoRepoFile().getCryptoRepoFileId()).updatePlainHistoCryptoRepoFile(histoCryptoRepoFile);
        }
    }

    private void removeFileChunkDtos(PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto) {
        RepoFileDto repoFileDto = plainHistoCryptoRepoFileDto.getRepoFileDto();
        if (repoFileDto instanceof SsNormalFileDto) {
            SsNormalFileDto normalFileDto = (SsNormalFileDto)repoFileDto;
            normalFileDto.setFileChunkDtos(null);
        }
    }

    private boolean isParentOrEqual(CryptoRepoFile parentCandidate, CryptoRepoFile childCandidate) {
        Objects.requireNonNull(parentCandidate, "parentCandidate");
        Objects.requireNonNull(childCandidate, "childCandidate");
        for (CryptoRepoFile crf = childCandidate; crf != null; crf = crf.getParent()) {
            if (!parentCandidate.equals((Object)crf)) continue;
            return true;
        }
        return false;
    }

    public PlainHistoCryptoRepoFileDto getPlainHistoCryptoRepoFileDto(Uid histoCryptoRepoFileId) {
        Objects.requireNonNull(histoCryptoRepoFileId, "histoCryptoRepoFileId");
        LocalRepoTransaction tx = this.getTransactionOrFail();
        HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)((Object)tx.getDao(HistoCryptoRepoFileDao.class));
        HistoCryptoRepoFile histoCryptoRepoFile = hcrfDao.getHistoCryptoRepoFileOrFail(histoCryptoRepoFileId);
        PlainHistoCryptoRepoFileDao phcrfDao = (PlainHistoCryptoRepoFileDao)((Object)tx.getDao(PlainHistoCryptoRepoFileDao.class));
        PlainHistoCryptoRepoFile phcrf = phcrfDao.getPlainHistoCryptoRepoFileOrFail(histoCryptoRepoFile);
        return phcrf.getPlainHistoCryptoRepoFileDto();
    }

    public void clearCryptoRepoFileDeleted(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(localPath);
        cryptreeNode.clearCryptoRepoFileDeleted();
    }

    public void putCollisionPrivateDto(CollisionPrivateDto collisionPrivateDto) {
        Objects.requireNonNull(collisionPrivateDto, "collisionPrivateDto");
        Uid collisionId = Objects.requireNonNull(collisionPrivateDto.getCollisionId(), "collisionPrivateDto.collisionId");
        CollisionDao cDao = (CollisionDao)((Object)this.getTransactionOrFail().getDao(CollisionDao.class));
        Collision collision = cDao.getCollisionOrFail(collisionId);
        Uid cryptoRepoFileId = collision.getHistoCryptoRepoFile1().getCryptoRepoFile().getCryptoRepoFileId();
        CryptreeNode cryptreeNode = this.getCryptreeContext().getCryptreeNodeOrCreate(cryptoRepoFileId);
        CollisionPrivateDto oldCollisionPrivateDto = cryptreeNode.getCollisionPrivateDto(collision);
        if (!this.isDeeplyEqual(collisionPrivateDto, oldCollisionPrivateDto)) {
            cryptreeNode.putCollisionPrivateDto(collision, collisionPrivateDto);
        }
    }

    public Long getLastCryptoKeySyncFromRemoteRepoRemoteRepositoryRevisionSynced() {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        RemoteRepository remoteRepository = ((RemoteRepositoryDao)tx.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(this.getRemoteRepositoryIdOrFail());
        LastCryptoKeySyncFromRemoteRepo lcksfrr = ((LastCryptoKeySyncFromRemoteRepoDao)((Object)tx.getDao(LastCryptoKeySyncFromRemoteRepoDao.class))).getLastCryptoKeySyncFromRemoteRepo(remoteRepository);
        if (lcksfrr == null) {
            return null;
        }
        long result = lcksfrr.getRemoteRepositoryRevisionSynced();
        return result == Long.MIN_VALUE ? null : Long.valueOf(result);
    }

    protected void setLastCryptoKeySyncFromRemoteRepoRemoteRepositoryRevisionSynced(long revision) {
        if (revision < 0L) {
            throw new IllegalArgumentException("revision < 0");
        }
        LocalRepoTransaction tx = this.getTransactionOrFail();
        RemoteRepository remoteRepository = ((RemoteRepositoryDao)tx.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(this.getRemoteRepositoryIdOrFail());
        LastCryptoKeySyncFromRemoteRepoDao lcksfrrDao = (LastCryptoKeySyncFromRemoteRepoDao)((Object)tx.getDao(LastCryptoKeySyncFromRemoteRepoDao.class));
        LastCryptoKeySyncFromRemoteRepo lcksfrr = lcksfrrDao.getLastCryptoKeySyncFromRemoteRepo(remoteRepository);
        if (lcksfrr == null) {
            lcksfrr = new LastCryptoKeySyncFromRemoteRepo();
            lcksfrr.setRemoteRepository(remoteRepository);
        }
        lcksfrr.setRemoteRepositoryRevisionSynced(revision);
        lcksfrrDao.makePersistent(lcksfrr);
    }

    private boolean isDeeplyEqual(CollisionPrivateDto dto1, CollisionPrivateDto dto2) {
        return Util.equal((Object)dto1.getCollisionId(), (Object)dto2.getCollisionId()) && Util.equal((Object)dto1.getComment(), (Object)dto2.getComment()) && Util.equal((Object)dto1.getResolved(), (Object)dto2.getResolved());
    }

    protected PersistenceManager pm() {
        return ((ContextWithPersistenceManager)this.getTransactionOrFail()).getPersistenceManager();
    }
}

