/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.local.persistence.Dao;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.repo.local.CollisionPrivateFilter;
import org.subshare.local.persistence.Collision;
import org.subshare.local.persistence.CollisionPrivate;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.SsRemoteRepository;
import org.subshare.local.persistence.SsRemoteRepositoryDao;

public class CollisionPrivateDao
extends Dao<CollisionPrivate, CollisionPrivateDao> {
    private static final Logger logger = LoggerFactory.getLogger(CollisionPrivateDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollisionPrivate getCollisionPrivate(Collision collision) {
        Objects.requireNonNull(collision, "collision");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCollisionPrivate_collision");
        try {
            CollisionPrivate result;
            CollisionPrivate collisionPrivate = result = (CollisionPrivate)((Object)query.execute((Object)collision));
            return collisionPrivate;
        }
        finally {
            query.closeAll();
        }
    }

    public CollisionPrivate getCollisionPrivateOrFail(Collision collision) {
        Objects.requireNonNull(collision, "collision");
        CollisionPrivate collisionPrivate = this.getCollisionPrivate(collision);
        if (collisionPrivate == null) {
            throw new IllegalArgumentException("There is no CollisionPrivate for " + (Object)((Object)collision));
        }
        return collisionPrivate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CollisionPrivate> getCollisionPrivates(CollisionPrivateFilter filter) {
        Objects.requireNonNull(filter, "filter");
        filter = this.prepareFilter(filter);
        if (filter == null) {
            return new HashSet<CollisionPrivate>();
        }
        Query query = this.pm().newQuery(CollisionPrivate.class);
        try {
            StringBuilder qf = new StringBuilder();
            HashMap<String, Object> qp = new HashMap<String, Object>();
            HashMap qv = new HashMap();
            CollisionPrivateDao.appendToQueryFilter_collisionIds(qf, qp, qv, filter.getCollisionIds());
            CollisionPrivateDao.appendToQueryFilter_histoCryptoRepoFileId(qf, qp, qv, filter.getHistoCryptoRepoFileId());
            if (filter.isIncludeChildrenRecursively()) {
                CollisionPrivateDao.appendToQueryFilter_cryptoRepoFileId_recursive(qf, qp, qv, filter.getCryptoRepoFileId());
            } else {
                CollisionPrivateDao.appendToQueryFilter_cryptoRepoFileId_nonRecursive(qf, qp, qv, filter.getCryptoRepoFileId());
            }
            this.appendToQueryFilter_resolved(qf, qp, qv, filter.getResolved());
            if (qf.length() > 0) {
                query.setFilter(qf.toString());
            }
            if (!qv.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry me : qv.entrySet()) {
                    sb.append(((Class)me.getValue()).getName()).append(' ').append((String)me.getKey()).append(';');
                }
                query.declareVariables(sb.toString());
            }
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.executeWithMap(qp);
            logger.info("getCollisionPrivates: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.info("getCollisionPrivates: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    private CollisionPrivateFilter prepareFilter(CollisionPrivateFilter filter) {
        Objects.requireNonNull(filter, "filter");
        if (filter.getLocalPath() != null && filter.getCryptoRepoFileId() != null) {
            throw new IllegalArgumentException("filter.localPath and filter.cryptoRepoFileId must not both be set! Exactly one of them!");
        }
        if (filter.getLocalPath() != null) {
            if ((filter = filter.clone()).getCryptoRepoFileId() != null) {
                throw new IllegalArgumentException("filter.localPath and filter.cryptoRepoFileId must not both be set! Exactly one of them!");
            }
            CryptoRepoFile filterCryptoRepoFile = this.getCryptoRepoFileForLocalPath(filter.getLocalPath());
            if (filterCryptoRepoFile == null) {
                return null;
            }
            filter.setLocalPath(null);
            filter.setCryptoRepoFileId(filterCryptoRepoFile.getCryptoRepoFileId());
        }
        return filter;
    }

    private static void appendToQueryFilter_collisionIds(StringBuilder qf, Map<String, Object> qp, Map<String, Class<?>> qv, Set<Uid> collisionIds) {
        Objects.requireNonNull(qf, "qf");
        Objects.requireNonNull(qp, "qp");
        if (collisionIds == null) {
            return;
        }
        HashSet<String> collisionIdsAsString = new HashSet<String>(collisionIds.size());
        for (Uid collisionId : collisionIds) {
            collisionIdsAsString.add(collisionId.toString());
        }
        CollisionPrivateDao.appendAndIfNeeded(qf);
        qf.append(" :collisionIds.contains(this.collisionId) ");
        qp.put("collisionIds", collisionIdsAsString);
    }

    private static void appendToQueryFilter_histoCryptoRepoFileId(StringBuilder qf, Map<String, Object> qp, Map<String, Class<?>> qv, Uid histoCryptoRepoFileId) {
        Objects.requireNonNull(qf, "qf");
        Objects.requireNonNull(qp, "qp");
        if (histoCryptoRepoFileId == null) {
            return;
        }
        CollisionPrivateDao.appendAndIfNeeded(qf);
        qf.append(" (").append("  this.collision.histoCryptoRepoFile1.histoCryptoRepoFileId == :histoCryptoRepoFileId").append("  || this.collision.histoCryptoRepoFile2.histoCryptoRepoFileId == :histoCryptoRepoFileId").append(") ");
        qp.put("histoCryptoRepoFileId", histoCryptoRepoFileId.toString());
    }

    private static void appendToQueryFilter_cryptoRepoFileId_nonRecursive(StringBuilder qf, Map<String, Object> qp, Map<String, Class<?>> qv, Uid cryptoRepoFileId) {
        Objects.requireNonNull(qf, "qf");
        Objects.requireNonNull(qp, "qp");
        Objects.requireNonNull(qv, "qv");
        if (cryptoRepoFileId == null) {
            return;
        }
        CollisionPrivateDao.appendAndIfNeeded(qf);
        qf.append(" (").append("  this.collision.histoCryptoRepoFile1.cryptoRepoFile.cryptoRepoFileId == :cryptoRepoFileId").append("  || this.collision.histoCryptoRepoFile2.cryptoRepoFile.cryptoRepoFileId == :cryptoRepoFileId").append(") ");
        qp.put("cryptoRepoFileId", cryptoRepoFileId.toString());
    }

    private static void appendToQueryFilter_cryptoRepoFileId_recursive(StringBuilder qf, Map<String, Object> qp, Map<String, Class<?>> qv, Uid cryptoRepoFileId) {
        Objects.requireNonNull(qf, "qf");
        Objects.requireNonNull(qp, "qp");
        Objects.requireNonNull(qv, "qv");
        if (cryptoRepoFileId == null) {
            return;
        }
        CollisionPrivateDao.appendAndIfNeeded(qf);
        qf.append(" ( this.collision.cryptoRepoFilePath.contains(crf) && crf.cryptoRepoFileId == :cryptoRepoFileId ) ");
        qv.put("crf", CryptoRepoFile.class);
        qp.put("cryptoRepoFileId", cryptoRepoFileId.toString());
    }

    private CryptoRepoFile getCryptoRepoFileForLocalPath(String localPath) {
        if (localPath == null) {
            return null;
        }
        SsRemoteRepository remoteRepository = ((SsRemoteRepositoryDao)this.getDao(SsRemoteRepositoryDao.class)).getUniqueRemoteRepository();
        if (remoteRepository == null) {
            return null;
        }
        CryptoRepoFile crf1 = ((CryptoRepoFileDao)this.getDao(CryptoRepoFileDao.class)).getCryptoRepoFile(remoteRepository, localPath);
        return crf1;
    }

    private void appendToQueryFilter_resolved(StringBuilder qf, Map<String, Object> qp, Map<String, Class<?>> qv, Boolean resolved) {
        Objects.requireNonNull(qf, "qf");
        Objects.requireNonNull(qp, "qp");
        Objects.requireNonNull(qv, "qv");
        if (resolved == null) {
            return;
        }
        CollisionPrivateDao.appendAndIfNeeded(qf);
        qf.append(" this.resolved ");
        if (resolved.booleanValue()) {
            qf.append(" != ");
        } else {
            qf.append(" == ");
        }
        qf.append("null ");
    }

    private static void appendAndIfNeeded(StringBuilder qf) {
        Objects.requireNonNull(qf, "qf");
        if (qf.length() > 0) {
            qf.append(" && ");
        }
    }
}

